/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import org.aksw.rdfunit.utils.PrefixNSService;

public final class ResultAnnotation {
    private final String annotationProperty;
    private final RDFNode annotationValue;

    public ResultAnnotation(String annotationProperty, RDFNode annotationValue) {
        assert (annotationProperty != null);
        assert (annotationValue != null);
        this.annotationProperty = annotationProperty;
        this.annotationValue = annotationValue;
    }

    public Resource serializeAsResult(Resource resource, Model model) {
        return resource.addProperty(ResourceFactory.createProperty((String)this.getAnnotationProperty()), this.getAnnotationValue());
    }

    public Resource serializeAsTestCase(Model model) {
        return model.createResource().addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev((String)"rut:ResultAnnotation"))).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:annotationProperty")), (RDFNode)model.createResource(this.annotationProperty)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:annotationValue")), this.annotationValue);
    }

    public String getAnnotationProperty() {
        return this.annotationProperty;
    }

    public RDFNode getAnnotationValue() {
        return this.annotationValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultAnnotation)) {
            return false;
        }
        ResultAnnotation that = (ResultAnnotation)o;
        if (!this.annotationProperty.equals(that.annotationProperty)) {
            return false;
        }
        return this.annotationValue.equals(that.annotationValue);
    }

    public int hashCode() {
        int result = this.annotationProperty.hashCode();
        result = 31 * result + this.annotationValue.hashCode();
        return result;
    }
}

