/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.utils.PrefixNSService;

public class AggregatedTestCaseResult
extends StatusTestCaseResult {
    private final long errorCount;
    private final long prevalenceCount;

    public AggregatedTestCaseResult(TestCase testCase, long errorCount, long prevalenceCount) {
        super(testCase, TestCaseResultStatus.resolve(errorCount));
        this.errorCount = errorCount;
        this.prevalenceCount = prevalenceCount;
    }

    public AggregatedTestCaseResult(TestCase testCase, TestCaseResultStatus status, long errorCount, long prevalenceCount) {
        super(testCase, status);
        this.errorCount = errorCount;
        this.prevalenceCount = prevalenceCount;
    }

    @Override
    public Resource serialize(Model model, String testExecutionURI) {
        return super.serialize(model, testExecutionURI).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getURIFromAbbrev((String)"rut:AggregatedTestResult"))).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:resultCount")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.errorCount), (RDFDatatype)XSDDatatype.XSDinteger)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev((String)"rut:resultPrevalence")), (RDFNode)ResourceFactory.createTypedLiteral((String)("" + this.prevalenceCount), (RDFDatatype)XSDDatatype.XSDinteger));
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getPrevalenceCount() {
        return this.prevalenceCount;
    }

    public String toString() {
        return "Errors: " + this.errorCount + " / Prevalence: " + this.prevalenceCount + ". Test: " + this.getTestCase().getAbrTestURI();
    }
}

