/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.query_generation.QueryGenerationFactory;
import org.aksw.rdfunit.tests.results.AggregatedTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;

public class AggregatedTestExecutor
extends TestExecutor {
    public AggregatedTestExecutor(QueryGenerationFactory queryGenerationFactory) {
        super(queryGenerationFactory);
    }

    @Override
    protected Collection<TestCaseResult> executeSingleTest(TestSource testSource, TestCase testCase) throws TestCaseExecutionException {
        int prevalence;
        int total;
        block8: {
            total = -1;
            prevalence = -1;
            try {
                Query prevalenceQuery = testCase.getSparqlPrevalenceQuery();
                if (prevalenceQuery != null) {
                    prevalence = this.getCountNumber(testSource.getExecutionFactory(), testCase.getSparqlPrevalenceQuery(), "total");
                }
            }
            catch (QueryExceptionHTTP e) {
                prevalence = SparqlUtils.checkStatusForTimeout(e) ? -1 : -2;
            }
            if (prevalence != 0) {
                try {
                    total = this.getCountNumber(testSource.getExecutionFactory(), this.queryGenerationFactory.getSparqlQuery(testCase), "total");
                }
                catch (QueryExceptionHTTP e) {
                    if (SparqlUtils.checkStatusForTimeout(e)) {
                        total = -1;
                        break block8;
                    }
                    total = -2;
                }
            } else {
                total = 0;
            }
        }
        return Arrays.asList(new AggregatedTestCaseResult(testCase, total, prevalence));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCountNumber(QueryExecutionFactory model, Query query, String var) {
        assert (query != null);
        assert (var != null);
        int result = 0;
        try (QueryExecution qe = null;){
            qe = model.createQueryExecution(query);
            ResultSet results = qe.execSelect();
            if (results != null && results.hasNext()) {
                QuerySolution qs = results.next();
                result = qs.get(var).asLiteral().getInt();
            }
        }
        return result;
    }
}

