/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.sources.EnrichedSchemaSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.utils.StringUtils;

public final class SourceFactory {
    private SourceFactory() {
    }

    public static SchemaSource createSchemaSourceFromCache(String baseFolder, String prefix, String uri) {
        return SourceFactory.createSchemaSourceFromCache(baseFolder, prefix, uri, uri);
    }

    public static SchemaSource createSchemaSourceFromCache(String baseFolder, String prefix, String uri, String schema) {
        String cacheFile = CacheUtils.getSchemaSourceCacheFilename(baseFolder, TestAppliesTo.Schema, prefix, uri);
        RDFReader reader = RDFReaderFactory.createFileOrDereferenceReader((String)cacheFile, (String)schema);
        return new SchemaSource(prefix, uri, schema, reader);
    }

    public static SchemaSource createSchemaSourceDereference(String prefix, String uri) {
        return SourceFactory.createSchemaSourceDereference(prefix, uri, uri);
    }

    public static SchemaSource createSchemaSourceDereference(String prefix, String uri, String schema) {
        RDFReader reader = RDFReaderFactory.createDereferenceReader((String)schema);
        return new SchemaSource(prefix, uri, schema, reader);
    }

    public static EnrichedSchemaSource createEnrichedSchemaSourceFromCache(String baseFolder, String prefix, String uri) {
        String cacheFile = CacheUtils.getSchemaSourceCacheFilename(baseFolder, TestAppliesTo.EnrichedSchema, prefix, uri);
        RDFReader reader = RDFReaderFactory.createFileOrDereferenceReader((String)cacheFile, (String)uri);
        return new EnrichedSchemaSource(prefix, uri, reader);
    }

    public static SchemaSource createSchemaSourceFromText(String namespace, String text, String format) {
        String uri = namespace + StringUtils.getHashFromString((String)text);
        String prefix = CacheUtils.getAutoPrefixForURI(uri);
        return new SchemaSource(prefix, uri, uri, RDFReaderFactory.createReaderFromText((String)text, (String)format));
    }
}

