/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.TestSource;

public class EndpointTestSource
extends TestSource {
    private final String sparqlEndpoint;
    private final Collection<String> sparqlGraph;

    public EndpointTestSource(String prefix, String uri) {
        this(prefix, uri, uri, new ArrayList<String>(), null);
    }

    public EndpointTestSource(String prefix, String uri, String sparqlEndpoint, Collection<String> sparqlGraph, Collection<SchemaSource> schemata) {
        super(prefix, uri);
        this.sparqlEndpoint = sparqlEndpoint;
        this.sparqlGraph = new ArrayList<String>(sparqlGraph);
        if (schemata != null) {
            this.addReferencesSchemata(schemata);
        }
    }

    public EndpointTestSource(EndpointTestSource source) {
        this(source.getPrefix(), source.getUri(), source.getSparqlEndpoint(), source.getSparqlGraphs(), source.getReferencesSchemata());
    }

    public EndpointTestSource(EndpointTestSource source, Collection<SchemaSource> referencesSchemata) {
        super(source);
        this.addReferencesSchemata(referencesSchemata);
        this.sparqlEndpoint = source.sparqlEndpoint;
        this.sparqlGraph = new ArrayList<String>(source.getSparqlGraphs());
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        QueryExecutionFactoryHttp qef = this.getSparqlGraphs() == null || this.getSparqlGraphs().isEmpty() ? new QueryExecutionFactoryHttp(this.getSparqlEndpoint()) : new QueryExecutionFactoryHttp(this.getSparqlEndpoint(), this.getSparqlGraphs());
        return this.masqueradeQEF((QueryExecutionFactory)qef);
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public Collection<String> getSparqlGraphs() {
        return this.sparqlGraph;
    }
}

