/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public final class Pattern {
    private final String id;
    private final String description;
    private final String sparqlWherePattern;
    private final String sparqlPatternPrevalence;
    private final Collection<PatternParameter> parameters;
    private final Collection<ResultAnnotation> annotations;

    public Pattern(String id, String description, String sparqlWherePattern, String sparqlPatternPrevalence, Collection<PatternParameter> parameters, Collection<ResultAnnotation> annotations) {
        assert (id != null);
        this.id = id;
        assert (description != null);
        this.description = description;
        assert (sparqlWherePattern != null);
        this.sparqlWherePattern = sparqlWherePattern;
        assert (sparqlPatternPrevalence != null);
        this.sparqlPatternPrevalence = sparqlPatternPrevalence;
        assert (parameters != null);
        this.parameters = parameters;
        assert (annotations != null);
        this.annotations = annotations;
    }

    public boolean isValid() {
        if (this.getParameters() == null || this.getParameters().isEmpty()) {
            return false;
        }
        for (PatternParameter p : this.getParameters()) {
            if (this.getSparqlWherePattern().contains("%%" + p.getId() + "%%")) continue;
            return false;
        }
        return true;
    }

    public Collection<ResultAnnotation> getBindedAnnotations(Collection<Binding> bindings) {
        ArrayList<ResultAnnotation> finalAnnotations = new ArrayList<ResultAnnotation>();
        Iterator<ResultAnnotation> i$ = this.annotations.iterator();
        while (i$.hasNext()) {
            ResultAnnotation externalAnnotation;
            ResultAnnotation sanitizedAnnotation = externalAnnotation = i$.next();
            if (externalAnnotation.getAnnotationValue().isLiteral()) {
                String value = externalAnnotation.getAnnotationValue().toString();
                for (Binding binding : bindings) {
                    if (!value.equals("%%" + binding.getParameterId() + "%%")) continue;
                    sanitizedAnnotation = new ResultAnnotation(externalAnnotation.getAnnotationProperty(), binding.getValue());
                }
            }
            finalAnnotations.add(sanitizedAnnotation);
        }
        return finalAnnotations;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSparqlWherePattern() {
        return this.sparqlWherePattern;
    }

    public String getSparqlPatternPrevalence() {
        return this.sparqlPatternPrevalence;
    }

    public Collection<PatternParameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public PatternParameter getParameter(String parameterURI) {
        for (PatternParameter parameter : this.parameters) {
            if (!parameter.getUri().equals(parameterURI)) continue;
            return parameter;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pattern)) {
            return false;
        }
        Pattern pattern = (Pattern)o;
        if (!this.annotations.equals(pattern.annotations)) {
            return false;
        }
        if (!this.description.equals(pattern.description)) {
            return false;
        }
        if (!this.id.equals(pattern.id)) {
            return false;
        }
        if (!this.parameters.equals(pattern.parameters)) {
            return false;
        }
        if (!this.sparqlPatternPrevalence.equals(pattern.sparqlPatternPrevalence)) {
            return false;
        }
        return this.sparqlWherePattern.equals(pattern.sparqlWherePattern);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.sparqlWherePattern.hashCode();
        result = 31 * result + this.sparqlPatternPrevalence.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }
}

