/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.writer;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.OutputStream;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.io.writer.RDFHTMLResultsStatusWriter;
import org.aksw.rdfunit.io.writer.RDFWriterException;
import org.aksw.rdfunit.utils.PrefixNSService;

public class RDFHTMLResultsAggregateWriter
extends RDFHTMLResultsStatusWriter {
    public RDFHTMLResultsAggregateWriter(String filename) {
        super(filename);
    }

    public RDFHTMLResultsAggregateWriter(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected StringBuffer getResultsHeader() {
        return new StringBuffer("<tr><th>Status</th><th>Level</th><th>Test Case</th><th>Errors</th><th>Prevalence</th></tr>");
    }

    @Override
    protected StringBuffer getResultsList(QueryExecutionFactory qef, String testExecutionURI) throws RDFWriterException {
        StringBuffer results = new StringBuffer();
        String template = "<tr class=\"%s\"><td>%s</td><td>%s</td><td><span title=\"%s\">%s</span></td><td>%s</td><td>%s</td></tr>";
        String sparql = PrefixNSService.getSparqlPrefixDecl() + " SELECT DISTINCT ?resultStatus ?level ?testcase ?description ?resultCount ?resultPrevalence WHERE {" + " ?s a rut:AggregatedTestResult ; " + "    rut:resultStatus ?resultStatus ; " + "    rut:testCaseLogLevel ?level ; " + "    rut:testCase ?testcase ;" + "    dcterms:description ?description ;" + "    rut:resultCount ?resultCount ; " + "    rut:resultPrevalence ?resultPrevalence ; " + "} ";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparql);
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String resultStatus = qs.get("resultStatus").toString();
                String testcase = qs.get("testcase").toString();
                String description = qs.get("description").toString();
                String resultCount = qs.get("resultCount").asLiteral().getValue().toString();
                String resultPrevalence = qs.get("resultPrevalence").asLiteral().getValue().toString();
                String level = qs.get("level").toString();
                String statusShort = resultStatus.replace(PrefixNSService.getNSFromPrefix((String)"rut") + "ResultStatus", "");
                String levelShort = PrefixNSService.getLocalName((String)level, (String)"rlog");
                String rowClass = this.getStatusClass(statusShort);
                String row = String.format(template, rowClass, "<a href=\"" + resultStatus + "\">" + statusShort + "</a>", "<a href=\"" + level + "\">" + levelShort + "</a>", testcase.replace(PrefixNSService.getNSFromPrefix((String)"rutt"), "rutt:"), description, resultCount, resultPrevalence);
                results.append(row);
            }
        }
        return results;
    }
}

