/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.enums;

import org.aksw.rdfunit.utils.PrefixNSService;

public enum RLOGLevel {
    ERROR,
    DEBUG,
    OFF,
    FATAL,
    WARN,
    TRACE,
    INFO,
    ALL;

    private static final String schemaPrefix = "rlog";

    public String getUri() {
        return PrefixNSService.getNSFromPrefix((String)schemaPrefix) + this.name();
    }

    public String toString() {
        return this.getUri();
    }

    public static RLOGLevel resolve(String value) {
        String qName = PrefixNSService.getLocalName((String)value, (String)schemaPrefix);
        for (RLOGLevel level : RLOGLevel.values()) {
            if (!qName.equals(level.name())) continue;
            return level;
        }
        return null;
    }
}

