/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.UndefinedSchemaException;
import org.aksw.rdfunit.exceptions.UndefinedSerializationException;
import org.aksw.rdfunit.io.format.FormatService;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.reader.RDFReader;
import org.aksw.rdfunit.io.reader.RDFReaderFactory;
import org.aksw.rdfunit.io.reader.RDFStreamReader;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.DumpTestSource;
import org.aksw.rdfunit.sources.EndpointTestSource;
import org.aksw.rdfunit.sources.EnrichedSchemaSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceFactory;
import org.aksw.rdfunit.sources.TestSource;
import org.aksw.rdfunit.sources.TestSourceFactory;
import org.aksw.rdfunit.statistics.NamespaceStatistics;

public class RDFUnitConfiguration {
    private final String datasetURI;
    private String prefix = null;
    private final String dataFolder;
    private final String testFolder;
    private String endpointURI = null;
    private Collection<String> endpointGraphs = null;
    private long endpointQueryDelayMS = -1L;
    private long endpointQueryCacheTTL = -1L;
    private long endpointQueryPagination = -1L;
    private long endpointQueryLimit = -1L;
    private String customDereferenceURI = null;
    private TestSource testSource = null;
    private String customTextSource = null;
    private SerializationFormat customTextFormat = null;
    private Collection<SchemaSource> schemas = null;
    private EnrichedSchemaSource enrichedSchema = null;
    private boolean testCacheEnabled = true;
    private boolean manualTestsEnabled = true;
    private boolean autoTestsEnabled = true;
    private TestCaseExecutionType testCaseExecutionType = TestCaseExecutionType.aggregatedTestCaseResult;
    private Collection<SerializationFormat> outputFormats = null;
    private boolean calculateCoverageEnabled = false;

    public RDFUnitConfiguration(String datasetURI, String dataFolder) {
        this(datasetURI, dataFolder, dataFolder + "tests/");
    }

    public RDFUnitConfiguration(String datasetURI, String dataFolder, String testFolder) {
        this.datasetURI = datasetURI;
        this.dataFolder = dataFolder;
        this.testFolder = testFolder;
        this.prefix = CacheUtils.getAutoPrefixForURI(datasetURI);
    }

    public void setEndpointConfiguration(String endpointURI, Collection<String> endpointGraphs) {
        this.endpointURI = endpointURI;
        this.endpointGraphs = new ArrayList<String>();
        this.endpointGraphs.addAll(endpointGraphs);
    }

    public void setCustomDereferenceURI(String customDereferenceURI) {
        this.customDereferenceURI = customDereferenceURI;
    }

    public void setCustomTextSource(String text, String format) throws UndefinedSerializationException {
        this.customTextSource = text;
        this.customTextFormat = FormatService.getInputFormat((String)format);
        if (this.customTextFormat == null) {
            throw new UndefinedSerializationException(format);
        }
        this.endpointURI = null;
        this.customDereferenceURI = null;
    }

    public void setAutoSchemataFromQEF(QueryExecutionFactory qef) {
        this.setAutoSchemataFromQEF(qef, false);
    }

    public void setAutoSchemataFromQEF(QueryExecutionFactory qef, boolean all) {
        this.setAutoSchemataFromQEF(qef, all, true);
    }

    public void setAutoSchemataFromQEF(QueryExecutionFactory qef, boolean all, boolean limitToKnown) {
        NamespaceStatistics namespaceStatistics;
        if (all) {
            namespaceStatistics = limitToKnown ? NamespaceStatistics.createCompleteNSStatisticsKnown() : NamespaceStatistics.createCompleteNSStatisticsAll();
        } else {
            NamespaceStatistics namespaceStatistics2 = namespaceStatistics = limitToKnown ? NamespaceStatistics.createOntologyNSStatisticsKnown() : NamespaceStatistics.createOntologyNSStatisticsAll();
        }
        assert (namespaceStatistics != null);
        this.schemas = namespaceStatistics.getNamespaces(qef);
    }

    public void setSchemataFromPrefixes(Collection<String> schemaPrefixes) throws UndefinedSchemaException {
        this.schemas = SchemaService.getSourceList(this.testFolder, schemaPrefixes);
    }

    public void setSchemata(Collection<SchemaSource> schemata) {
        this.schemas = new ArrayList<SchemaSource>();
        this.schemas.addAll(schemata);
    }

    public void setEnrichedSchema(String enrichedSchemaPrefix) {
        if (enrichedSchemaPrefix != null && !enrichedSchemaPrefix.isEmpty()) {
            this.enrichedSchema = SourceFactory.createEnrichedSchemaSourceFromCache(this.testFolder, enrichedSchemaPrefix, this.datasetURI);
        }
    }

    public Collection<SchemaSource> getAllSchemata() {
        ArrayList<SchemaSource> allSchemas = new ArrayList<SchemaSource>();
        if (this.schemas != null) {
            allSchemas.addAll(this.schemas);
        }
        if (this.enrichedSchema != null) {
            allSchemas.add(this.enrichedSchema);
        }
        return allSchemas;
    }

    public TestSource getTestSource() {
        if (this.testSource != null) {
            Collection<SchemaSource> schemata = this.getAllSchemata();
            if (this.testSource.getReferencesSchemata().isEmpty() && !schemata.isEmpty()) {
                this.testSource = TestSourceFactory.createTestSource(this.testSource, schemata);
            }
            return this.testSource;
        }
        String prefix = CacheUtils.getAutoPrefixForURI(this.datasetURI);
        if (this.endpointURI != null && !this.endpointURI.isEmpty()) {
            this.testSource = new EndpointTestSource(prefix, this.datasetURI, this.endpointURI, this.endpointGraphs, this.getAllSchemata());
        } else {
            RDFReader dumpReader;
            if (this.customTextSource != null) {
                dumpReader = RDFReaderFactory.createReaderFromText((String)this.customTextSource, (String)this.customTextFormat.getName());
            } else {
                String tmp_customDereferenceURI = this.datasetURI;
                if (this.customDereferenceURI != null && !this.customDereferenceURI.isEmpty()) {
                    tmp_customDereferenceURI = this.customDereferenceURI;
                }
                dumpReader = this.customDereferenceURI != null && "-".equals(this.customDereferenceURI) ? new RDFStreamReader((InputStream)new BufferedInputStream(System.in), "TURTLE") : RDFReaderFactory.createDereferenceReader((String)tmp_customDereferenceURI);
            }
            this.testSource = new DumpTestSource(prefix, this.datasetURI, dumpReader, this.getAllSchemata());
        }
        if (this.endpointQueryCacheTTL != -1L) {
            this.testSource.setCacheTTL(this.endpointQueryCacheTTL);
        }
        if (this.endpointQueryDelayMS != -1L) {
            this.testSource.setQueryDelay(this.endpointQueryDelayMS);
        }
        if (this.endpointQueryPagination != -1L) {
            this.testSource.setPagination(this.endpointQueryPagination);
        }
        if (this.endpointQueryLimit != -1L) {
            this.testSource.setQueryLimit(this.endpointQueryLimit);
        }
        return this.testSource;
    }

    public void setOutputFormatTypes(Collection<String> outputNames) throws UndefinedSerializationException {
        this.outputFormats = new ArrayList<SerializationFormat>();
        for (String name : outputNames) {
            SerializationFormat serializationFormat = FormatService.getOutputFormat((String)name);
            if (serializationFormat != null) {
                this.outputFormats.add(serializationFormat);
                continue;
            }
            throw new UndefinedSerializationException(name);
        }
        if (this.outputFormats.isEmpty()) {
            throw new UndefinedSerializationException("");
        }
    }

    public boolean isTestCacheEnabled() {
        return this.testCacheEnabled;
    }

    public void setTestCacheEnabled(boolean testCacheEnabled) {
        this.testCacheEnabled = testCacheEnabled;
    }

    public boolean isManualTestsEnabled() {
        return this.manualTestsEnabled;
    }

    public void setManualTestsEnabled(boolean manualTestsEnabled) {
        this.manualTestsEnabled = manualTestsEnabled;
    }

    public boolean isAutoTestsEnabled() {
        return this.autoTestsEnabled;
    }

    public void setAutoTestsEnabled(boolean autoTestsEnabled) {
        this.autoTestsEnabled = autoTestsEnabled;
        if (!this.autoTestsEnabled) {
            this.setTestCacheEnabled(false);
        }
    }

    public TestCaseExecutionType getTestCaseExecutionType() {
        return this.testCaseExecutionType;
    }

    public void setTestCaseExecutionType(TestCaseExecutionType testCaseExecutionType) {
        this.testCaseExecutionType = testCaseExecutionType;
    }

    public boolean isCalculateCoverageEnabled() {
        return this.calculateCoverageEnabled;
    }

    public void setCalculateCoverageEnabled(boolean calculateCoverageEnabled) {
        this.calculateCoverageEnabled = calculateCoverageEnabled;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public String getTestFolder() {
        return this.testFolder;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDatasetURI() {
        return this.datasetURI;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public Collection<String> getEndpointGraphs() {
        return this.endpointGraphs;
    }

    public String getCustomDereferenceURI() {
        return this.customDereferenceURI;
    }

    public EnrichedSchemaSource getEnrichedSchema() {
        return this.enrichedSchema;
    }

    public Collection<SerializationFormat> getOutputFormats() {
        return this.outputFormats;
    }

    public SerializationFormat geFirstOutputFormat() {
        return RDFUnitUtils.getFirstItemInCollection(this.outputFormats);
    }

    public long getEndpointQueryDelayMS() {
        return this.endpointQueryDelayMS;
    }

    public void setEndpointQueryDelayMS(long endpointQueryDelayMS) {
        this.endpointQueryDelayMS = endpointQueryDelayMS;
    }

    public long getEndpointQueryCacheTTL() {
        return this.endpointQueryCacheTTL;
    }

    public void setEndpointQueryCacheTTL(long endpointQueryCacheTTL) {
        this.endpointQueryCacheTTL = endpointQueryCacheTTL;
    }

    public long getEndpointQueryPagination() {
        return this.endpointQueryPagination;
    }

    public void setEndpointQueryPagination(long endpointQueryPagination) {
        this.endpointQueryPagination = endpointQueryPagination;
    }

    public long getEndpointQueryLimit() {
        return this.endpointQueryLimit;
    }

    public void setEndpointQueryLimit(long endpointQueryLimit) {
        this.endpointQueryLimit = endpointQueryLimit;
    }
}

