/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.services.PrefixService;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public class TestCaseAnnotation {
    private final TestGenerationType generated;
    private final String autoGeneratorURI;
    private final TestAppliesTo appliesTo;
    private final String sourceUri;
    private final Collection<String> references;
    private final String description;
    private final String testCaseLogLevel;
    private final Collection<ResultAnnotation> resultAnnotations;

    public TestCaseAnnotation(TestGenerationType generated, String autoGeneratorURI, TestAppliesTo appliesTo, String sourceUri, Collection<String> references, String description, String testCaseLogLevel, Collection<ResultAnnotation> resultAnnotations) {
        this.generated = generated;
        this.autoGeneratorURI = autoGeneratorURI;
        this.appliesTo = appliesTo;
        this.sourceUri = sourceUri;
        this.references = references;
        this.description = description;
        this.resultAnnotations = new ArrayList<ResultAnnotation>();
        this.resultAnnotations.addAll(resultAnnotations);
        this.testCaseLogLevel = this.findAnnotationLevel(testCaseLogLevel);
    }

    public Resource serialize(Resource resource, Model model) {
        resource.addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("dcterms"), (String)"description"), this.description).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"generated"), (RDFNode)model.createResource(this.getGenerated().getUri())).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testGenerator"), (RDFNode)model.createResource(this.getAutoGeneratorURI())).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"appliesTo"), (RDFNode)model.createResource(this.getAppliesTo().getUri())).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"source"), (RDFNode)model.createResource(this.getSourceUri())).addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"testCaseLogLevel"), (RDFNode)model.createResource(this.getTestCaseLogLevel()));
        for (String r : this.getReferences()) {
            resource.addProperty(model.createProperty(PrefixService.getPrefix("rut") + "references"), (RDFNode)ResourceFactory.createResource((String)r));
        }
        for (ResultAnnotation annotation : this.resultAnnotations) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixService.getPrefix("rut"), (String)"resultAnnotation"), (RDFNode)annotation.serializeAsTestCase(model));
        }
        return resource;
    }

    public TestGenerationType getGenerated() {
        return this.generated;
    }

    public String getAutoGeneratorURI() {
        return this.autoGeneratorURI;
    }

    public TestAppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public Collection<String> getReferences() {
        return this.references;
    }

    private String findAnnotationLevel(String testCaseLogLevel) {
        String logLevel = testCaseLogLevel;
        ResultAnnotation pointer = null;
        for (ResultAnnotation annotation : this.resultAnnotations) {
            if (!annotation.getAnnotationProperty().equals(PrefixService.getPrefix("rlog") + "level")) continue;
            pointer = annotation;
        }
        if (pointer != null) {
            if (logLevel == null || logLevel.equals("")) {
                logLevel = pointer.getAnnotationValue().toString();
            }
            this.resultAnnotations.remove(pointer);
        }
        return logLevel;
    }

    public String getTestCaseLogLevel() {
        return this.testCaseLogLevel;
    }

    public Collection<ResultAnnotation> getResultAnnotations() {
        return this.resultAnnotations;
    }

    public String getDescription() {
        return this.description;
    }
}

