/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.SchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Source
implements Comparable<Source> {
    protected static final Logger log = LoggerFactory.getLogger(Source.class);
    private final String prefix;
    private final String uri;
    private final Collection<SchemaSource> referencesSchemata;
    private QueryExecutionFactory queryFactory;

    public Source(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
        this.referencesSchemata = new ArrayList<SchemaSource>();
    }

    public Source(Source source) {
        this(source.getPrefix(), source.getUri());
        this.referencesSchemata.addAll(source.getReferencesSchemata());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public abstract TestAppliesTo getSourceType();

    protected abstract QueryExecutionFactory initQueryFactory();

    public QueryExecutionFactory getExecutionFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.initQueryFactory();
        }
        return this.queryFactory;
    }

    public Collection<SchemaSource> getReferencesSchemata() {
        return this.referencesSchemata;
    }

    public void addReferencesSchemata(Collection<SchemaSource> schemata) {
        this.referencesSchemata.addAll(schemata);
    }

    @Override
    public int compareTo(Source o) {
        if (this.getPrefix().equals(o.getPrefix()) && this.getUri().equals(o.getUri())) {
            return 0;
        }
        return this.getPrefix().compareTo(o.getPrefix());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Source) {
            return this.compareTo((Source)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getPrefix() + " (" + this.getUri() + ")";
    }
}

