/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.DataReader;

public class RDFFileReader
extends DataReader {
    private final InputStream file;
    private final String format;

    public RDFFileReader(String filename) {
        this(RDFFileReader.getStreamFromFilename(filename), "TURTLE");
    }

    public RDFFileReader(InputStream file) {
        this(file, "TURTLE");
    }

    public RDFFileReader(String filename, String format) {
        this(RDFFileReader.getStreamFromFilename(filename), format);
    }

    public RDFFileReader(InputStream file, String format) {
        this.file = file;
        this.format = format;
    }

    @Override
    public void read(Model model) throws TripleReaderException {
        try {
            model.read(this.file, null, this.format);
        }
        catch (Exception e) {
            throw new TripleReaderException(e.getMessage());
        }
    }

    private static InputStream getStreamFromFilename(String filename) {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

