/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.io.HTMLResultsWriter;
import org.aksw.rdfunit.services.PrefixService;

public class HTMLResultsRlogWriter
extends HTMLResultsWriter {
    public HTMLResultsRlogWriter(String filename) {
        super(filename);
    }

    @Override
    protected StringBuffer getResultsHeader() {
        return new StringBuffer("<tr><th>Level</th><th>Message</th><th>Resource</th><th>Test Case</th></tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StringBuffer getResultsList(QueryExecutionFactory qef, String testExecutionURI) {
        StringBuffer results = new StringBuffer();
        String template = "<tr><td>%s</td><td>%s</ts><td><a href=\"%s\">%s</a></td><td>%s</td></tr>";
        String sparql = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?level ?message ?resource ?testcase WHERE {" + " ?s a rut:RLOGTestCaseResult ; " + "    rlog:level ?level ;" + "    rlog:message ?message ; " + "    rlog:resource ?resource ; " + "    rut:testCase ?testcase ; " + "} ";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparql);
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String level = qs.get("level").toString();
                String message = qs.get("message").toString();
                String resource = qs.get("resource").toString();
                String testcase = qs.get("testcase").toString();
                String row = String.format(template, level.replace(PrefixService.getPrefix("rlog"), "rlog:"), message, resource, resource, testcase.replace(PrefixService.getPrefix("rutt"), "rutt:"));
                results.append(row);
            }
        }
        return results;
    }
}

