/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.tests.QueryGenerationAskFactory;
import org.aksw.rdfunit.tests.QueryGenerationCountFactory;
import org.aksw.rdfunit.tests.QueryGenerationExtendedSelectFactory;
import org.aksw.rdfunit.tests.QueryGenerationSelectFactory;
import org.aksw.rdfunit.tests.executors.AggregatedTestExecutor;
import org.aksw.rdfunit.tests.executors.ExtendedTestExecutor;
import org.aksw.rdfunit.tests.executors.RLOGTestExecutor;
import org.aksw.rdfunit.tests.executors.StatusTestExecutor;
import org.aksw.rdfunit.tests.executors.TestExecutor;

public final class TestExecutorFactory {
    private TestExecutorFactory() {
    }

    public static TestExecutor createTestExecutor(TestCaseExecutionType executionType) {
        switch (executionType) {
            case statusTestCaseResult: {
                return new StatusTestExecutor(new QueryGenerationAskFactory());
            }
            case aggregatedTestCaseResult: {
                return new AggregatedTestExecutor(new QueryGenerationCountFactory());
            }
            case rlogTestCaseResult: {
                return new RLOGTestExecutor(new QueryGenerationSelectFactory());
            }
            case extendedTestCaseResult: {
                return new ExtendedTestExecutor(new QueryGenerationExtendedSelectFactory());
            }
        }
        return null;
    }
}

