/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import com.hp.hpl.jena.query.QueryExecution;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.QueryGenerationFactory;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;

public class StatusTestExecutor
extends TestExecutor {
    public StatusTestExecutor(QueryGenerationFactory queryGenerationFactory) {
        super(queryGenerationFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<TestCaseResult> executeSingleTest(Source source, TestCase testCase) throws TestCaseExecutionException {
        TestCaseResultStatus status = TestCaseResultStatus.Error;
        try (QueryExecution qe = null;){
            qe = source.getExecutionFactory().createQueryExecution(this.queryGenerationFactory.getSparqlQuery(testCase));
            boolean fail = qe.execAsk();
            status = fail ? TestCaseResultStatus.Fail : TestCaseResultStatus.Success;
        }
        return Arrays.asList(new StatusTestCaseResult(testCase, status));
    }
}

