/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public class TestCaseAnnotation {
    private final TestGenerationType generated;
    private final String autoGeneratorURI;
    private final TestAppliesTo appliesTo;
    private final String sourceUri;
    private final Collection<String> references;
    private final String description;
    private final RLOGLevel testCaseLogLevel;
    private final Collection<ResultAnnotation> resultAnnotations;
    private final Collection<ResultAnnotation> variableAnnotations;

    public TestCaseAnnotation(TestGenerationType generated, String autoGeneratorURI, TestAppliesTo appliesTo, String sourceUri, Collection<String> references, String description, RLOGLevel testCaseLogLevel, Collection<ResultAnnotation> resultAnnotations) {
        this.generated = generated;
        this.autoGeneratorURI = autoGeneratorURI;
        this.appliesTo = appliesTo;
        this.sourceUri = sourceUri;
        this.references = references;
        this.description = description;
        this.resultAnnotations = new ArrayList<ResultAnnotation>();
        this.resultAnnotations.addAll(resultAnnotations);
        this.testCaseLogLevel = this.findAnnotationLevel(testCaseLogLevel);
        this.variableAnnotations = this.findVariableAnnotations();
    }

    public Resource serialize(Resource resource, Model model) {
        resource.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("dcterms:description")), this.description).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:generated")), (RDFNode)model.createResource(this.getGenerated().getUri())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:testGenerator")), (RDFNode)model.createResource(this.getAutoGeneratorURI())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:appliesTo")), (RDFNode)model.createResource(this.getAppliesTo().getUri())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:source")), (RDFNode)model.createResource(this.getSourceUri())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:testCaseLogLevel")), (RDFNode)model.createResource(this.getTestCaseLogLevel().getUri()));
        for (String r : this.getReferences()) {
            resource.addProperty(model.createProperty(PrefixNSService.getURIFromAbbrev("rut:references")), (RDFNode)ResourceFactory.createResource((String)r));
        }
        for (ResultAnnotation annotation : this.resultAnnotations) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:resultAnnotation")), (RDFNode)annotation.serializeAsTestCase(model));
        }
        for (ResultAnnotation annotation : this.variableAnnotations) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getURIFromAbbrev("rut:resultAnnotation")), (RDFNode)annotation.serializeAsTestCase(model));
        }
        return resource;
    }

    public TestGenerationType getGenerated() {
        return this.generated;
    }

    public String getAutoGeneratorURI() {
        return this.autoGeneratorURI;
    }

    public TestAppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public Collection<String> getReferences() {
        return this.references;
    }

    private RLOGLevel findAnnotationLevel(RLOGLevel testCaseLogLevel) {
        RLOGLevel logLevel = testCaseLogLevel;
        ResultAnnotation pointer = null;
        for (ResultAnnotation annotation : this.resultAnnotations) {
            if (!annotation.getAnnotationProperty().equals(PrefixNSService.getURIFromAbbrev("rlog:level"))) continue;
            pointer = annotation;
        }
        if (pointer != null) {
            if (logLevel == null) {
                logLevel = RLOGLevel.resolve(pointer.getAnnotationValue().toString());
            }
            this.resultAnnotations.remove(pointer);
        }
        return logLevel;
    }

    private Collection<ResultAnnotation> findVariableAnnotations() {
        ArrayList<ResultAnnotation> variableAnnotations = new ArrayList<ResultAnnotation>();
        ResultAnnotation pointer = null;
        for (ResultAnnotation annotation : this.resultAnnotations) {
            String value = annotation.getAnnotationValue().toString().trim();
            if (!value.startsWith("?")) continue;
            pointer = annotation;
            variableAnnotations.add(annotation);
        }
        if (pointer != null) {
            this.resultAnnotations.remove(pointer);
        }
        return variableAnnotations;
    }

    public RLOGLevel getTestCaseLogLevel() {
        return this.testCaseLogLevel;
    }

    public Collection<ResultAnnotation> getResultAnnotations() {
        return this.resultAnnotations;
    }

    public Collection<ResultAnnotation> getVariableAnnotations() {
        return this.variableAnnotations;
    }

    public String getDescription() {
        return this.description;
    }
}

