/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.statistics;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.SchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatasetStatistics {
    private static final Logger log = LoggerFactory.getLogger(DatasetStatistics.class);
    private final QueryExecutionFactory qef;
    private final boolean doGetCounts;
    private static final String propertyStatsSPARQL = PrefixNSService.getSparqlPrefixDecl() + " SELECT DISTINCT ?stats WHERE {" + "     ?s ?stats ?o . } ";
    private static final String propertyStatsSPARQLwithCounts = PrefixNSService.getSparqlPrefixDecl() + " SELECT ?stats (count( DISTINCT ?stats) AS ?count) WHERE {" + "     ?s ?stats ?o . } " + " GROUP BY ?stats ";
    private static final String classStatsSPARQL = PrefixNSService.getSparqlPrefixDecl() + " SELECT DISTINCT ?stats WHERE {" + "     ?s a ?stats . } ";
    private static final String classStatsSPARQLwithCounts = PrefixNSService.getSparqlPrefixDecl() + " SELECT ?stats (count( DISTINCT ?stats ) AS ?count) WHERE {" + "     ?s a ?stats . } " + " GROUP BY ?stats ";
    private final Collection<String> excludePrefixes = Arrays.asList("rdf", "rdfs", "owl");

    public DatasetStatistics(QueryExecutionFactory qef, boolean doGetCounts) {
        this.qef = qef;
        this.doGetCounts = doGetCounts;
    }

    public Map<String, Integer> getPropertyStats() {
        if (this.doGetCounts) {
            return this.getStats(propertyStatsSPARQLwithCounts);
        }
        return this.getStats(propertyStatsSPARQL);
    }

    public Map<String, Integer> getClassStats() {
        if (this.doGetCounts) {
            return this.getStats(classStatsSPARQLwithCounts);
        }
        return this.getStats(classStatsSPARQL);
    }

    public Collection<String> getAllNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        for (String n : this.getPropertyStats().keySet()) {
            namespaces.add(this.getNamespaceFromURI(n));
        }
        for (String n : this.getClassStats().keySet()) {
            namespaces.add(this.getNamespaceFromURI(n));
        }
        return namespaces;
    }

    public Collection<SchemaSource> getIdentifiedSchemata() {
        ArrayList<SchemaSource> sources = new ArrayList<SchemaSource>();
        for (String namespace : this.getAllNamespaces()) {
            SchemaSource source = SchemaService.getSourceFromUri(namespace);
            if (source != null) {
                if (this.excludePrefixes.contains(source.getPrefix())) continue;
                sources.add(source);
                continue;
            }
            log.warn("Undefined namespace in LOV or schemaDecl.csv: " + namespace);
        }
        return sources;
    }

    protected String getNamespaceFromURI(String uri) {
        String breakChar = "/";
        if (uri.contains("#")) {
            breakChar = "#";
        }
        int pos = Math.min(uri.lastIndexOf(breakChar), uri.length());
        return uri.substring(0, pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Integer> getStats(String sparqlQuery) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        try (QueryExecution qe = null;){
            qe = this.qef.createQueryExecution(sparqlQuery);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String s = qs.get("stats").toString();
                int c = 0;
                if (this.doGetCounts) {
                    c = qs.get("count").asLiteral().getInt();
                }
                stats.put(s, c);
            }
        }
        return stats;
    }
}

