/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.RDFReader;
import org.aksw.rdfunit.sources.Source;

public class SchemaSource
extends Source {
    protected final String schema;
    protected final RDFReader schemaReader;

    public SchemaSource(String prefix, String uri, RDFReader schemaReader) {
        this(prefix, uri, uri, schemaReader);
    }

    public SchemaSource(String prefix, String uri, String schema, RDFReader schemaReader) {
        super(prefix, uri);
        this.schema = schema;
        this.schemaReader = schemaReader;
    }

    public SchemaSource(SchemaSource source) {
        super(source);
        this.schema = source.getSchema();
        this.schemaReader = source.schemaReader;
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Schema;
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        try {
            this.schemaReader.read((Model)model);
        }
        catch (TripleReaderException e) {
            log.error("Cannot load ontology: " + this.getSchema() + " Reason: " + e.getMessage(), (Throwable)e);
        }
        return new QueryExecutionFactoryModel((Model)model);
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public String toString() {
        return this.getPrefix() + " (" + this.getSchema() + ")";
    }
}

