/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.io.RDFReader;
import org.aksw.rdfunit.io.RDFReaderFactory;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;

public class DumpTestSource
extends Source {
    private final RDFReader dumpReader;

    public DumpTestSource(String prefix, String uri) {
        this(prefix, uri, RDFReaderFactory.createDereferenceReader(uri), null);
    }

    public DumpTestSource(String prefix, String uri, String location) {
        this(prefix, uri, location, null);
    }

    public DumpTestSource(String prefix, String uri, String location, Collection<SchemaSource> schemata) {
        this(prefix, uri, RDFReaderFactory.createDereferenceReader(location), schemata);
    }

    public DumpTestSource(String prefix, String uri, RDFReader dumpReader, Collection<SchemaSource> schemata) {
        super(prefix, uri);
        this.dumpReader = dumpReader;
        if (schemata != null) {
            this.addReferencesSchemata(schemata);
        }
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        try {
            this.dumpReader.read((Model)model);
            for (Source source : this.getReferencesSchemata()) {
                QueryExecutionFactory qef = source.getExecutionFactory();
                if (!(qef instanceof QueryExecutionFactoryModel)) continue;
                model.add(((QueryExecutionFactoryModel)qef).getModel());
            }
        }
        catch (Exception e) {
            log.error("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage());
            throw new IllegalArgumentException("Dump source (" + this.getUri() + ") does not exists", e);
        }
        return new QueryExecutionFactoryModel((Model)model);
    }
}

