/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.services;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.exceptions.UndefinedSchemaException;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceFactory;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public final class SchemaService {
    private static final BidiMap<String, String> schemata = new DualHashBidiMap();

    private SchemaService() {
    }

    public static void addSchemaDecl(String prefix, String uri, String url) {
        schemata.put((Object)prefix, (Object)(uri + "\t" + url));
    }

    public static void addSchemaDecl(String prefix, String uri) {
        schemata.put((Object)prefix, (Object)uri);
    }

    public static SchemaSource getSourceFromUri(String uri) {
        return SchemaService.getSourceFromUri(null, uri);
    }

    public static SchemaSource getSourceFromUri(String baseFolder, String uri) {
        String prefix = (String)schemata.getKey((Object)uri);
        if (prefix == null) {
            return null;
        }
        return SchemaService.getSourceFromPrefix(baseFolder, prefix);
    }

    public static SchemaSource getSourceFromPrefix(String prefix) {
        return SchemaService.getSourceFromPrefix(null, prefix);
    }

    public static SchemaSource getSourceFromPrefix(String baseFolder, String prefix) {
        String sourceUriURL = (String)schemata.get((Object)prefix);
        if (sourceUriURL == null) {
            if (prefix.contains("/") || prefix.contains("\\")) {
                return SourceFactory.createSchemaSourceDereference(CacheUtils.getAutoPrefixForURI(prefix), prefix);
            }
            return null;
        }
        String[] split = sourceUriURL.split("\t");
        if (split.length == 2) {
            if (baseFolder != null) {
                return SourceFactory.createSchemaSourceFromCache(baseFolder, prefix, split[0], split[1]);
            }
            return SourceFactory.createSchemaSourceDereference(prefix, split[0], split[1]);
        }
        if (baseFolder != null) {
            return SourceFactory.createSchemaSourceFromCache(baseFolder, prefix, split[0]);
        }
        return SourceFactory.createSchemaSourceDereference(prefix, split[0]);
    }

    public static Collection<SchemaSource> getSourceList(String baseFolder, Collection<String> prefixes) throws UndefinedSchemaException {
        ArrayList<SchemaSource> sources = new ArrayList<SchemaSource>();
        for (String id : prefixes) {
            SchemaSource src = SchemaService.getSourceFromPrefix(baseFolder, id.trim());
            if (src != null) {
                sources.add(src);
                continue;
            }
            throw new UndefinedSchemaException(id);
        }
        return sources;
    }

    public static Collection<SchemaSource> getSourceListAll(boolean fileCache, String baseFolder) throws UndefinedSchemaException {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.addAll(schemata.keySet());
        if (fileCache) {
            return SchemaService.getSourceList(baseFolder, prefixes);
        }
        return SchemaService.getSourceList(null, prefixes);
    }
}

