/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public class Pattern {
    private final String id;
    private final String description;
    private final String sparqlWherePattern;
    private final String sparqlPatternPrevalence;
    private final Collection<PatternParameter> parameters;
    private final Collection<ResultAnnotation> annotations;

    public Pattern(String id, String description, String sparqlWherePattern, String sparqlPatternPrevalence, Collection<PatternParameter> parameters, Collection<ResultAnnotation> annotations) {
        this.id = id;
        this.description = description;
        this.sparqlWherePattern = sparqlWherePattern;
        this.sparqlPatternPrevalence = sparqlPatternPrevalence;
        this.parameters = parameters;
        this.annotations = annotations;
    }

    public boolean isValid() {
        if (this.getParameters() == null || this.getParameters().size() == 0) {
            return false;
        }
        for (PatternParameter p : this.getParameters()) {
            if (this.getSparqlWherePattern().contains("%%" + p.getId() + "%%")) continue;
            return false;
        }
        return true;
    }

    public Collection<ResultAnnotation> getBindedAnnotations(Collection<Binding> bindings) {
        ArrayList<ResultAnnotation> finalAnnotations = new ArrayList<ResultAnnotation>();
        Iterator<ResultAnnotation> i$ = this.annotations.iterator();
        while (i$.hasNext()) {
            ResultAnnotation externalAnnotation;
            ResultAnnotation sanitizedAnnotation = externalAnnotation = i$.next();
            if (externalAnnotation.getAnnotationValue().isLiteral()) {
                String value = externalAnnotation.getAnnotationValue().toString();
                for (Binding binding : bindings) {
                    if (!value.equals("%%" + binding.getParameterId() + "%%")) continue;
                    sanitizedAnnotation = new ResultAnnotation(externalAnnotation.getAnnotationProperty(), binding.getValue());
                }
            }
            finalAnnotations.add(sanitizedAnnotation);
        }
        return finalAnnotations;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSparqlWherePattern() {
        return this.sparqlWherePattern;
    }

    public String getSparqlPatternPrevalence() {
        return this.sparqlPatternPrevalence;
    }

    public Collection<PatternParameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public PatternParameter getParameter(String parameterURI) {
        for (PatternParameter parameter : this.parameters) {
            if (!parameter.getUri().equals(parameterURI)) continue;
            return parameter;
        }
        return null;
    }
}

