/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.io.format.SerializationFormatType;

public final class SerialiazationFormatFactory {
    private SerialiazationFormatFactory() {
    }

    public static Collection<SerializationFormat> getAllFormats() {
        ArrayList<SerializationFormat> serializationFormats = new ArrayList<SerializationFormat>();
        serializationFormats.add(SerialiazationFormatFactory.createTurtle());
        serializationFormats.add(SerialiazationFormatFactory.createN3());
        serializationFormats.add(SerialiazationFormatFactory.createNTriples());
        serializationFormats.add(SerialiazationFormatFactory.createJsonLD());
        serializationFormats.add(SerialiazationFormatFactory.createRDFJson());
        serializationFormats.add(SerialiazationFormatFactory.createRDFXMLAbbrevOut());
        serializationFormats.add(SerialiazationFormatFactory.createRDFXMLIn());
        serializationFormats.add(SerialiazationFormatFactory.createRDFXMLOut());
        serializationFormats.add(SerialiazationFormatFactory.createHTML());
        return serializationFormats;
    }

    public static SerializationFormat createHTML() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("html", "htm"));
        return new SerializationFormat("html", SerializationFormatType.output, "html", "text/html", currentSynonyms);
    }

    public static SerializationFormat createTurtle() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("turtle", "ttl"));
        return new SerializationFormat("TURTLE", SerializationFormatType.inputAndOutput, "ttl", "text/turtle", currentSynonyms);
    }

    public static SerializationFormat createN3() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        return new SerializationFormat("N3", SerializationFormatType.inputAndOutput, "n3", "rdf+n3", currentSynonyms);
    }

    public static SerializationFormat createNTriples() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("n-triple", "n-triples", "ntriple", "ntriples"));
        return new SerializationFormat("N-TRIPLE", SerializationFormatType.inputAndOutput, "nt", "application/n-triples", currentSynonyms);
    }

    public static SerializationFormat createJsonLD() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("JSON-LD", "JSONLD", "JSON/LD"));
        return new SerializationFormat("JSON-LD", SerializationFormatType.inputAndOutput, "jsonld", "application/ld+json", currentSynonyms);
    }

    public static SerializationFormat createRDFJson() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("RDF/JSON", "RDF-JSON", "RDFJSON"));
        return new SerializationFormat("RDF/JSON", SerializationFormatType.inputAndOutput, "rj", "application/rdf+json", currentSynonyms);
    }

    public static SerializationFormat createRDFXMLAbbrevOut() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("RDF/XML-ABBREV", "RDF-XML-ABBREV", "RDFXMLABBREV"));
        return new SerializationFormat("RDF/XML-ABBREV", SerializationFormatType.output, "rdf", "application/rdf+xml", currentSynonyms);
    }

    public static SerializationFormat createRDFXMLOut() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("RDF/XML", "RDF-XML", "RDFXML"));
        return new SerializationFormat("RDF/XML", SerializationFormatType.output, "rdf", "application/rdf+xml", currentSynonyms);
    }

    public static SerializationFormat createRDFXMLIn() {
        HashSet<String> currentSynonyms = new HashSet<String>();
        currentSynonyms.addAll(Arrays.asList("RDF/XML", "RDF-XML", "RDFXML", "RDF/XML-ABBREV", "RDF-XML-ABBREV", "RDFXML-ABBREV", "RDFXMLABBREV"));
        return new SerializationFormat("RDF/XML", SerializationFormatType.input, "rdf", "application/rdf+xml", currentSynonyms);
    }
}

