/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import java.io.OutputStream;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.io.RDFFileWriter;
import org.aksw.rdfunit.io.RDFHTMLResultsAggregateWriter;
import org.aksw.rdfunit.io.RDFHTMLResultsRlogWriter;
import org.aksw.rdfunit.io.RDFHTMLResultsStatusWriter;
import org.aksw.rdfunit.io.RDFHTMLResultsWriter;
import org.aksw.rdfunit.io.RDFStreamWriter;
import org.aksw.rdfunit.io.RDFWriter;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.services.FormatService;

public final class RDFWriterFactory {
    private RDFWriterFactory() {
    }

    public static RDFWriter createWriterFromFormat(String filenameWithoutExtension, SerializationFormat serializationFormat, TestCaseExecutionType executionType) {
        if (serializationFormat.equals(FormatService.getOutputFormat("html"))) {
            return RDFWriterFactory.createHTMLWriter(executionType, filenameWithoutExtension + "." + serializationFormat.getExtension());
        }
        return new RDFFileWriter(filenameWithoutExtension + "." + serializationFormat.getExtension(), serializationFormat.getName());
    }

    public static RDFWriter createWriterFromFormat(OutputStream outputStream, SerializationFormat serializationFormat, TestCaseExecutionType executionType) {
        if (serializationFormat.equals(FormatService.getOutputFormat("html"))) {
            return RDFWriterFactory.createHTMLWriter(executionType, outputStream);
        }
        return new RDFStreamWriter(outputStream, serializationFormat.getName());
    }

    public static RDFHTMLResultsWriter createHTMLWriter(TestCaseExecutionType type, String filename) {
        switch (type) {
            case statusTestCaseResult: {
                return new RDFHTMLResultsStatusWriter(filename);
            }
            case aggregatedTestCaseResult: {
                return new RDFHTMLResultsAggregateWriter(filename);
            }
            case rlogTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(filename);
            }
            case extendedTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(filename);
            }
        }
        return null;
    }

    public static RDFHTMLResultsWriter createHTMLWriter(TestCaseExecutionType type, OutputStream outputStream) {
        switch (type) {
            case statusTestCaseResult: {
                return new RDFHTMLResultsStatusWriter(outputStream);
            }
            case aggregatedTestCaseResult: {
                return new RDFHTMLResultsAggregateWriter(outputStream);
            }
            case rlogTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(outputStream);
            }
            case extendedTestCaseResult: {
                return new RDFHTMLResultsRlogWriter(outputStream);
            }
        }
        return null;
    }
}

