/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import java.util.ArrayList;
import org.aksw.rdfunit.io.RDFDereferenceReader;
import org.aksw.rdfunit.io.RDFFileWriter;
import org.aksw.rdfunit.io.RDFFirstSuccessReader;
import org.aksw.rdfunit.io.RDFReadAndCacheReader;
import org.aksw.rdfunit.io.RDFReader;
import org.aksw.rdfunit.io.RDFStreamReader;

public final class RDFReaderFactory {
    private RDFReaderFactory() {
    }

    public static RDFReader createFileOrDereferenceReader(String filenameOrUri) {
        return RDFReaderFactory.createFileOrDereferenceReader(filenameOrUri, filenameOrUri);
    }

    public static RDFReader createFileOrDereferenceReader(String filename, String uri) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        readers.add(new RDFStreamReader(filename));
        readers.add(new RDFDereferenceReader(uri));
        RDFFirstSuccessReader r = new RDFFirstSuccessReader(readers);
        RDFFileWriter w = new RDFFileWriter(filename, true);
        return new RDFReadAndCacheReader(r, w);
    }

    public static RDFReader createResourceReader(String resource) {
        return new RDFStreamReader(RDFReaderFactory.class.getResourceAsStream(resource));
    }

    public static RDFReader createFileOrResourceReader(String filename, String resource) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        readers.add(new RDFStreamReader(filename));
        readers.add(RDFReaderFactory.createResourceReader(resource));
        return new RDFFirstSuccessReader(readers);
    }

    public static RDFReader createDereferenceReader(String uri) {
        ArrayList<RDFReader> readers = new ArrayList<RDFReader>();
        if (uri.contains("://")) {
            readers.add(new RDFDereferenceReader(uri));
        } else {
            readers.add(new RDFStreamReader(uri));
            readers.add(new RDFStreamReader(RDFReaderFactory.class.getResourceAsStream(uri)));
        }
        return new RDFFirstSuccessReader(readers);
    }
}

