/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.Collection;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.RDFReader;

public class RDFFirstSuccessReader
extends RDFReader {
    private final Collection<RDFReader> readers;

    public RDFFirstSuccessReader(Collection<RDFReader> readers) {
        this.readers = readers;
    }

    @Override
    public void read(Model model) throws TripleReaderException {
        StringBuilder message = new StringBuilder();
        for (RDFReader r : this.readers) {
            try {
                r.read(model);
                return;
            }
            catch (TripleReaderException e) {
                message.append("\n");
                if (e.getMessage() != null) {
                    message.append(e.getMessage());
                    continue;
                }
                message.append(e.toString());
            }
        }
        throw new TripleReaderException("Cannot read from any reader: " + message.toString());
    }
}

