/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aksw.rdfunit.io.RDFMultipleReader;
import org.aksw.rdfunit.io.RDFReader;
import org.aksw.rdfunit.io.RDFStreamReader;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.EndpointTestSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFUnitUtils {
    private static final Logger log = LoggerFactory.getLogger(RDFUnitUtils.class);

    private RDFUnitUtils() {
    }

    public static void fillSchemaServiceFromFile(String additionalCSV) {
        try (FileInputStream inputStream = new FileInputStream(additionalCSV);){
            RDFUnitUtils.fillSchemaServiceFromFile(inputStream);
        }
        catch (FileNotFoundException e) {
            log.error("File " + additionalCSV + " not fount!", (Throwable)e);
        }
        catch (IOException e) {
            log.error("File " + additionalCSV + " not fount!", (Throwable)e);
        }
    }

    public static void fillSchemaServiceFromFile(InputStream additionalCSV) {
        int count = 0;
        if (additionalCSV != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(additionalCSV, "UTF-8"));){
                String line = null;
                block18: while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    ++count;
                    String[] parts = line.split(",");
                    switch (parts.length) {
                        case 2: {
                            SchemaService.addSchemaDecl(parts[0], parts[1]);
                            continue block18;
                        }
                        case 3: {
                            SchemaService.addSchemaDecl(parts[0], parts[1], parts[2]);
                            continue block18;
                        }
                    }
                    log.error("Invalid schema declaration in " + additionalCSV + ". Line: " + line);
                    --count;
                }
            }
            catch (UnsupportedEncodingException e) {
                log.debug("UnsupportedEncodingException: ", (Throwable)e);
                return;
            }
            catch (IOException e) {
                log.debug("IOException: ", (Throwable)e);
            }
            log.info("Loaded " + count + " schema declarations from: " + additionalCSV);
        }
        if (additionalCSV != null) {
            try {
                additionalCSV.close();
            }
            catch (IOException e) {
                log.debug("IOException: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillSchemaServiceFromLOV() {
        EndpointTestSource lov = new EndpointTestSource("lov", "http://lov.okfn.org", "http://lov.okfn.org/endpoint/lov", new ArrayList<String>(), null);
        int count = 0;
        try (QueryExecution qe = null;){
            qe = lov.getExecutionFactory().createQueryExecution("PREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX dcterms:<http://purl.org/dc/terms/>\nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl:<http://www.w3.org/2002/07/owl#>\nPREFIX skos:<http://www.w3.org/2004/02/skos/core#>\nPREFIX foaf:<http://xmlns.com/foaf/0.1/>\nPREFIX void:<http://rdfs.org/ns/void#>\nPREFIX bibo:<http://purl.org/ontology/bibo/>\nPREFIX vann:<http://purl.org/vocab/vann/>\nPREFIX voaf:<http://purl.org/vocommons/voaf#>\nPREFIX frbr:<http://purl.org/vocab/frbr/core#>\nPREFIX lov:<http://lov.okfn.org/dataset/lov/lov#>\n\nSELECT ?vocabURI ?vocabPrefix ?vocabNamespace\nWHERE{\n\t?vocabURI a voaf:Vocabulary.\n\t?vocabURI vann:preferredNamespacePrefix ?vocabPrefix.\n\t?vocabURI vann:preferredNamespaceUri ?vocabNamespace.\n} \nORDER BY ?vocabPrefix ");
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution row = rs.next();
                String prefix = row.get("vocabPrefix").toString();
                String vocab = row.get("vocabURI").toString();
                String ns = row.get("vocabNamespace").toString();
                if (ns == null || ns.isEmpty()) {
                    ns = vocab;
                }
                SchemaService.addSchemaDecl(prefix, ns);
                ++count;
            }
        }
        log.info("Loaded " + count + " schema declarations from LOV SPARQL Endpoint");
    }

    public static boolean fileExists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static RDFReader getPatternsFromResource() {
        return new RDFStreamReader(RDFUnitUtils.class.getResourceAsStream("/org/aksw/rdfunit/patterns.ttl"));
    }

    public static RDFReader getAutoGeneratorsOWLFromResource() {
        return new RDFStreamReader(RDFUnitUtils.class.getResourceAsStream("/org/aksw/rdfunit/autoGeneratorsOWL.ttl"));
    }

    public static RDFReader getAutoGeneratorsDSPFromResource() {
        return new RDFStreamReader(RDFUnitUtils.class.getResourceAsStream("/org/aksw/rdfunit/autoGeneratorsDSP.ttl"));
    }

    public static RDFReader getAutoGeneratorsALLFromResource() {
        List<RDFReader> readers = Arrays.asList(RDFUnitUtils.getAutoGeneratorsOWLFromResource(), RDFUnitUtils.getAutoGeneratorsDSPFromResource());
        return new RDFMultipleReader(readers);
    }

    public static <T> T getFirstItemInCollection(Collection<T> collection) {
        Iterator<T> i$ = collection.iterator();
        if (i$.hasNext()) {
            T item = i$.next();
            return item;
        }
        return null;
    }
}

