/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.enums.PatternParameterConstraints;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public final class PatternUtils {
    private PatternUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Pattern> instantiatePatternsFromModel(QueryExecutionFactory queryFactory) {
        String sparqlSelectPatterns = PrefixNSService.getSparqlPrefixDecl() + "SELECT distinct ?sparqlPattern WHERE { " + " ?sparqlPattern a rut:Pattern . }";
        ArrayList<String> patternURIs = new ArrayList<String>();
        try (QueryExecution qe = null;){
            qe = queryFactory.createQueryExecution(sparqlSelectPatterns);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                patternURIs.add(qs.get("sparqlPattern").toString());
            }
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String patternURI : patternURIs) {
            patterns.add(PatternUtils.getPattern(queryFactory, patternURI));
        }
        return patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern getPattern(QueryExecutionFactory queryFactory, String patternURI) {
        String sparqlSelectPattern = PrefixNSService.getSparqlPrefixDecl() + "SELECT distinct ?sparqlPattern ?id ?desc ?sparql ?sparqlPrev ?variable WHERE { " + "  <" + patternURI + "> a rut:Pattern ; " + "  dcterms:identifier ?id ; " + "  dcterms:description ?desc ; " + "  rut:sparqlWherePattern ?sparql ; " + "  rut:sparqlPrevalencePattern ?sparqlPrev ; " + "} ORDER BY ?sparqlPattern";
        Pattern pattern = null;
        try (QueryExecution qe = null;){
            Collection<ResultAnnotation> annotations;
            Collection<PatternParameter> parameters;
            String sparqlPrev;
            String sparql;
            String desc;
            QuerySolution qs;
            String id;
            qe = queryFactory.createQueryExecution(sparqlSelectPattern);
            ResultSet results = qe.execSelect();
            if (results.hasNext() && (!(pattern = new Pattern(id = (qs = results.next()).get("id").toString(), desc = qs.get("desc").toString(), sparql = qs.get("sparql").toString(), sparqlPrev = qs.get("sparqlPrev").toString(), parameters = PatternUtils.getPatternParameters(queryFactory, patternURI), annotations = SparqlUtils.getResultAnnotations(queryFactory, patternURI))).isValid() || results.hasNext())) {
                throw new IllegalArgumentException("Pattern not valid: " + pattern.getId());
            }
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<PatternParameter> getPatternParameters(QueryExecutionFactory queryFactory, String patternURI) {
        String sparqlSelectParameters = PrefixNSService.getSparqlPrefixDecl() + " SELECT distinct ?parameterURI ?id ?constraint ?constraintPattern WHERE { " + " %%PATTERN%%  rut:parameter ?parameterURI . " + " ?parameterURI a rut:Parameter . " + " ?parameterURI dcterms:identifier ?id . " + " OPTIONAL {?parameterURI rut:parameterConstraint ?constraint .}" + " OPTIONAL {?parameterURI rut:constraintPattern ?constraintPattern .}" + " } ";
        ArrayList<PatternParameter> parameters = new ArrayList<PatternParameter>();
        try (QueryExecution qe = null;){
            qe = queryFactory.createQueryExecution(sparqlSelectParameters.replace("%%PATTERN%%", "<" + patternURI + ">"));
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution parSol = rs.next();
                String parameterURI = parSol.get("parameterURI").toString();
                String parameterID = parSol.get("id").toString();
                String constrainStr = "";
                if (parSol.contains("constrain")) {
                    constrainStr = parSol.get("constrain").toString();
                }
                String constrainPat = "";
                if (parSol.contains("constraintPattern")) {
                    constrainPat = parSol.get("constraintPattern").toString();
                }
                PatternParameterConstraints constrain = PatternParameterConstraints.resolve(constrainStr);
                parameters.add(new PatternParameter(parameterURI, parameterID, constrain, constrainPat));
            }
        }
        return parameters;
    }
}

