package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.query.Query;

/**
 * Factory that returns ASK queries
 *
 * @author Dimitris Kontokostas
 * @since 7/25/14 10:10 PM
 */
public class QueryGenerationAskFactory implements QueryGenerationFactory {

    private final QueryGenerationSelectFactory queryGenerationSelectFactory = new QueryGenerationSelectFactory();

    @Override
    public String getSparqlQueryAsString(TestCase testCase) {
        return getSparqlQuery(testCase).toString();
    }

    @Override
    public Query getSparqlQuery(TestCase testCase) {
        Query query = queryGenerationSelectFactory.getSparqlQuery(testCase);
        query.setQueryAskType();
        return query;
    }
}
