/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.results.RLOGTestCaseResult;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public class ExtendedTestCaseResult
extends RLOGTestCaseResult {
    private final Collection<ResultAnnotation> resultAnnotations;

    public ExtendedTestCaseResult(TestCase testCase, String resource, String message, RLOGLevel logLevel) {
        super(testCase, resource, message, logLevel);
        this.resultAnnotations = testCase.getResultAnnotations();
    }

    public ExtendedTestCaseResult(TestCase testCase, RLOGTestCaseResult rlogResult) {
        super(testCase, rlogResult.getResource(), rlogResult.getMessage(), rlogResult.getLogLevel());
        this.resultAnnotations = testCase.getResultAnnotations();
    }

    @Override
    public Resource serialize(Model model, String testExecutionURI) {
        Resource resource = super.serialize(model, testExecutionURI).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getNSFromPrefix("rut") + "ExtendedTestCaseResult"));
        for (ResultAnnotation annotation : this.resultAnnotations) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getNSFromPrefix("rut"), (String)"resultAnnotation"), (RDFNode)annotation.serializeAsTestCase(model));
        }
        return resource;
    }
}

