/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.executors;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseResultStatus;
import org.aksw.rdfunit.exceptions.TestCaseExecutionException;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.monitors.TestExecutorMonitor;
import org.aksw.rdfunit.tests.results.RLOGTestCaseResult;
import org.aksw.rdfunit.tests.results.StatusTestCaseResult;
import org.aksw.rdfunit.tests.results.TestCaseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestExecutor {
    private static Logger log = LoggerFactory.getLogger(TestExecutor.class);
    private volatile boolean isCanceled = false;
    private final Collection<TestExecutorMonitor> progressMonitors = new ArrayList<TestExecutorMonitor>();

    public void cancel() {
        this.isCanceled = true;
    }

    protected abstract Collection<TestCaseResult> executeSingleTest(Source var1, TestCase var2) throws TestCaseExecutionException;

    public void execute(Source source, TestSuite testSuite, int delay) {
        this.isCanceled = false;
        for (TestExecutorMonitor monitor : this.progressMonitors) {
            monitor.testingStarted(source, testSuite);
        }
        for (TestCase testCase : testSuite.getTestCases()) {
            TestCaseResultStatus status;
            if (this.isCanceled) break;
            for (TestExecutorMonitor monitor : this.progressMonitors) {
                monitor.singleTestStarted(testCase);
            }
            Collection<Object> results = new ArrayList();
            long executionTimeStartInMS = System.currentTimeMillis();
            log.debug(testCase.getAbrTestURI() + " : started execution");
            try {
                results = this.executeSingleTest(source, testCase);
            }
            catch (TestCaseExecutionException e) {
                status = e.getStatus();
            }
            catch (Exception e) {
                String message = "Unknown error while executing TC: " + testCase.getAbrTestURI();
                log.error(message, (Throwable)e);
                if (e instanceof RuntimeException) {
                    throw new RuntimeException(message, e);
                }
                status = TestCaseResultStatus.Error;
            }
            long executionTimeEndInMS = System.currentTimeMillis();
            log.debug(testCase.getAbrTestURI() + " : execution completed in " + (executionTimeEndInMS - executionTimeStartInMS) + "ms");
            if (results.size() == 0) {
                status = TestCaseResultStatus.Success;
            } else if (results.size() > 1) {
                status = TestCaseResultStatus.Fail;
            } else {
                status = TestCaseResultStatus.Error;
                TestCaseResult r = (TestCaseResult)RDFUnitUtils.getFirstItemInCollection(results);
                if (r instanceof StatusTestCaseResult) {
                    status = ((StatusTestCaseResult)r).getStatus();
                } else if (r instanceof RLOGTestCaseResult) {
                    status = TestCaseResultStatus.Fail;
                }
            }
            for (TestExecutorMonitor monitor : this.progressMonitors) {
                monitor.singleTestExecuted(testCase, status, results);
            }
            if (delay <= 0) continue;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {}
        }
        for (TestExecutorMonitor monitor : this.progressMonitors) {
            monitor.testingFinished();
        }
    }

    public void addTestExecutorMonitor(TestExecutorMonitor monitor) {
        this.progressMonitors.add(monitor);
    }

    public void removeTestExecutorMonitor(TestExecutorMonitor monitor) {
        this.progressMonitors.remove(monitor);
    }
}

