/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Collection;
import java.util.List;
import org.aksw.rdfunit.enums.RLOGLevel;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestCase
implements Comparable<TestCase> {
    protected Logger log = LoggerFactory.getLogger(TestCase.class);
    private final String testURI;
    private final TestCaseAnnotation annotation;

    public TestCase(String testURI, TestCaseAnnotation annotation) throws TestCaseInstantiationException {
        this.testURI = testURI;
        this.annotation = annotation;
    }

    public Model getUnitTestModel() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        this.serialize((Model)model);
        return model;
    }

    public abstract String getSparqlWhere();

    public abstract String getSparqlPrevalence();

    public Resource serialize(Model model) {
        Resource resource = model.createResource(this.testURI);
        this.annotation.serialize(resource, model);
        return resource;
    }

    public String getSparql() {
        return " SELECT DISTINCT ?resource WHERE " + this.getSparqlWhere();
    }

    public Query getSparqlQuery() {
        return QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + this.getSparql()));
    }

    public String getSparqlAsCount() {
        return " SELECT (count(DISTINCT ?resource ) AS ?total ) WHERE " + this.getSparqlWhere();
    }

    public Query getSparqlAsCountQuery() {
        return QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + this.getSparqlAsCount()));
    }

    public String getSparqlAsAsk() {
        return this.getSparqlAsAskQuery().toString();
    }

    public Query getSparqlAsAskQuery() {
        Query q = this.getSparqlQuery();
        q.setQueryAskType();
        return q;
    }

    public Query getSparqlAnnotatedQuery() {
        return this.getSparqlQuery();
    }

    public String getSparqlAnnotated() {
        return this.getSparql();
    }

    public String getResultMessage() {
        return this.annotation.getDescription();
    }

    public RLOGLevel getLogLevel() {
        return this.annotation.getTestCaseLogLevel();
    }

    public Collection<ResultAnnotation> getResultAnnotations() {
        return this.annotation.getResultAnnotations();
    }

    public Query getSparqlPrevalenceQuery() {
        if (this.getSparqlPrevalence().trim().isEmpty()) {
            return null;
        }
        return QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + this.getSparqlPrevalence()));
    }

    public String getTestURI() {
        return this.testURI;
    }

    public String getAbrTestURI() {
        return this.testURI.replace(PrefixNSService.getNSFromPrefix("rutt"), "rutt:");
    }

    public void validateQueries() throws TestCaseInstantiationException {
        this.validateSPARQL(this.getSparql(), "SPARQL");
        this.validateSPARQL(this.getSparqlAsCount(), "SPARQL Count");
        this.validateSPARQL(this.getSparqlAsAsk(), "ASK");
        this.validateSPARQL(this.getSparqlAnnotated(), "construct");
        if (!this.getSparqlPrevalence().trim().equals("")) {
            this.validateSPARQL(this.getSparqlPrevalence(), "prevalence");
        }
        List vars = this.getSparqlQuery().getResultVars();
        boolean hasResource = false;
        for (String v : vars) {
            if (!v.equals("resource")) continue;
            hasResource = true;
        }
        if (!hasResource) {
            throw new TestCaseInstantiationException("?resource is not included in SELECT for Test: " + this.testURI);
        }
        if (this.annotation.getDescription().equals("")) {
            throw new TestCaseInstantiationException("No test case dcterms:description message included in TestCase: " + this.testURI);
        }
        if (this.getLogLevel() == null) {
            throw new TestCaseInstantiationException("No (or malformed) log level included for Test: " + this.testURI);
        }
    }

    private void validateSPARQL(String sparql, String type) throws TestCaseInstantiationException {
        try {
            QueryFactory.create((String)(PrefixNSService.getSparqlPrefixDecl() + sparql));
        }
        catch (QueryParseException e) {
            String message = "QueryParseException in " + type + " query (line " + e.getLine() + ", column " + e.getColumn() + " for Test: " + this.testURI + "\n" + PrefixNSService.getSparqlPrefixDecl() + sparql;
            throw new TestCaseInstantiationException(message, e);
        }
    }

    @Override
    public int compareTo(TestCase o) {
        return this.getTestURI().compareTo(o.getTestURI());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestCase) {
            return this.getTestURI().compareTo(((TestCase)obj).getTestURI()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getTestURI();
    }
}

