/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;

public class EndpointTestSource
extends Source {
    public static final long CACHE_TTL = 604800000L;
    public static final long PAGINATION = 800L;
    public static final long QUERY_DELAY = 5000L;
    public static final long QUERY_LIMIT = 799L;
    private long cacheTTL = 604800000L;
    private long queryDelay = 5000L;
    private long queryLimit = 799L;
    private long pagination = 800L;
    private final String sparqlEndpoint;
    private final Collection<String> sparqlGraph;

    public EndpointTestSource(String prefix, String uri) {
        this(prefix, uri, uri, new ArrayList<String>(), null);
    }

    public EndpointTestSource(String prefix, String uri, String sparqlEndpoint, Collection<String> sparqlGraph, Collection<SchemaSource> schemata) {
        super(prefix, uri);
        this.sparqlEndpoint = sparqlEndpoint;
        this.sparqlGraph = new ArrayList<String>(sparqlGraph);
        if (schemata != null) {
            this.addReferencesSchemata(schemata);
        }
    }

    public EndpointTestSource(EndpointTestSource source) {
        this(source.getPrefix(), source.getUri(), source.getSparqlEndpoint(), source.getSparqlGraphs(), source.getReferencesSchemata());
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        QueryExecutionFactoryHttp qef = this.getSparqlGraphs() == null || this.getSparqlGraphs().isEmpty() ? new QueryExecutionFactoryHttp(this.getSparqlEndpoint()) : new QueryExecutionFactoryHttp(this.getSparqlEndpoint(), this.getSparqlGraphs());
        if (this.queryDelay > 0L) {
            qef = new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, this.queryDelay);
        }
        if (this.cacheTTL > 0L) {
            try {
                QueryExecutionFactory _qef = CacheUtilsH2.createQueryExecutionFactory((QueryExecutionFactory)qef, (String)("./cache/sparql/" + this.getPrefix()), (boolean)false, (long)this.cacheTTL);
                qef = _qef;
                log.debug("Cache for endpoint set up: " + this.getSparqlEndpoint());
            }
            catch (Exception e) {
                log.debug("Could not instantiate cache for Endpoint" + this.getSparqlEndpoint(), (Throwable)e);
            }
        }
        if (this.pagination > 0L) {
            qef = new QueryExecutionFactoryPaginated((QueryExecutionFactory)qef, 900L);
        }
        if (this.queryLimit > 0L || this.queryLimit < Long.MIN_VALUE) {
            qef = new QueryExecutionFactoryLimit((QueryExecutionFactory)qef, true, Long.valueOf(this.queryLimit));
        }
        return qef;
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public Collection<String> getSparqlGraphs() {
        return this.sparqlGraph;
    }

    public void setCacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void setQueryDelay(long queryDelay) {
        this.queryDelay = queryDelay;
    }

    public void setQueryLimit(long queryLimit) {
        this.queryLimit = queryLimit;
    }

    public void setPagination(long pagination) {
        this.pagination = pagination;
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public long getQueryDelay() {
        return this.queryDelay;
    }

    public long getQueryLimit() {
        return this.queryLimit;
    }

    public long getPagination() {
        return this.pagination;
    }
}

