/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io.format;

import java.util.HashSet;
import java.util.Set;
import org.aksw.rdfunit.io.format.SerializationFormatType;

public class SerializationFormat {
    private final String name;
    private final SerializationFormatType type;
    private final String extension;
    private final String headerType;
    private final Set<String> synonyms;

    public SerializationFormat(String name, SerializationFormatType type, String extension, String headerType) {
        this(name, type, extension, headerType, new HashSet<String>());
    }

    public SerializationFormat(String name, SerializationFormatType type, String extension, String headerType, Set<String> synonyms) {
        this.name = name;
        this.type = type;
        this.extension = extension;
        this.headerType = headerType;
        this.synonyms = new HashSet<String>();
        for (String synonym : synonyms) {
            this.synonyms.add(synonym.toLowerCase());
        }
    }

    public boolean isAcceptedAsInput(String format) {
        if (this.type.equals((Object)SerializationFormatType.output)) {
            return false;
        }
        return this.containsFormatName(format);
    }

    public boolean isAcceptedAsOutput(String format) {
        if (this.type.equals((Object)SerializationFormatType.input)) {
            return false;
        }
        return this.containsFormatName(format);
    }

    private boolean containsFormatName(String format) {
        if (this.name.equalsIgnoreCase(format)) {
            return true;
        }
        return this.synonyms.contains(format.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getHeaderType() {
        return this.headerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SerializationFormat)) {
            return false;
        }
        SerializationFormat that = (SerializationFormat)o;
        if (!this.extension.equals(that.extension)) {
            return false;
        }
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }
}

