/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.DataReader;

public class RDFStreamReader
extends DataReader {
    private final InputStream inputStream;
    private final String format;

    public RDFStreamReader(String filename) {
        this(RDFStreamReader.getInputStreamFromFilename(filename), "TURTLE");
    }

    public RDFStreamReader(InputStream inputStream) {
        this(inputStream, "TURTLE");
    }

    public RDFStreamReader(String filename, String format) {
        this(RDFStreamReader.getInputStreamFromFilename(filename), format);
    }

    public RDFStreamReader(InputStream inputStream, String format) {
        this.inputStream = inputStream;
        this.format = format;
    }

    @Override
    public void read(Model model) throws TripleReaderException {
        try {
            model.read(this.inputStream, null, this.format);
        }
        catch (Exception e) {
            throw new TripleReaderException(e.getMessage(), e);
        }
    }

    private static InputStream getInputStreamFromFilename(String filename) {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

