/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.io.OutputStream;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.io.HTMLResultsWriter;
import org.aksw.rdfunit.services.PrefixNSService;

public class HTMLResultsStatusWriter
extends HTMLResultsWriter {
    public HTMLResultsStatusWriter(String filename) {
        super(filename);
    }

    public HTMLResultsStatusWriter(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected StringBuffer getResultsHeader() {
        return new StringBuffer("<tr><th>Status</th><th>Test Case</th></tr>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StringBuffer getResultsList(QueryExecutionFactory qef, String testExecutionURI) {
        StringBuffer results = new StringBuffer();
        String template = "<tr class=\"%s\"><td><a href=\"%s\">%s</a></td><td><span title=\"%s\">%s</span></td></tr>";
        String sparql = PrefixNSService.getSparqlPrefixDecl() + " SELECT DISTINCT ?resultStatus ?testcase ?description WHERE {" + " ?s a rut:StatusTestCaseResult ; " + "    rut:resultStatus ?resultStatus ; " + "    rut:testCase ?testcase ;" + "    dcterms:description ?description ;" + "} ";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparql);
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String resultStatus = qs.get("resultStatus").toString();
                String testcase = qs.get("testcase").toString();
                String description = qs.get("description").toString();
                String statusShort = resultStatus.replace(PrefixNSService.getNSFromPrefix("rut") + "ResultStatus", "");
                String rowClass = this.getStatusClass(statusShort);
                String row = String.format(template, rowClass, resultStatus, statusShort, testcase.replace(PrefixNSService.getNSFromPrefix("rutt"), "rutt:"), description);
                results.append(row);
            }
        }
        return results;
    }

    protected String getStatusClass(String status) {
        switch (status) {
            case "Success": {
                return "success";
            }
            case "Fail": {
                return "danger";
            }
            case "Timeout": {
                return "warning";
            }
            case "Error": {
                return "warning";
            }
        }
        return "";
    }
}

