/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import java.io.OutputStream;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.io.DataWriter;
import org.aksw.rdfunit.io.HTMLResultsAggregateWriter;
import org.aksw.rdfunit.io.HTMLResultsRlogWriter;
import org.aksw.rdfunit.io.HTMLResultsStatusWriter;
import org.aksw.rdfunit.io.HTMLResultsWriter;
import org.aksw.rdfunit.io.RDFFileWriter;
import org.aksw.rdfunit.io.RDFStreamWriter;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.services.FormatService;

public final class DataWriterFactory {
    protected DataWriterFactory() {
    }

    public static DataWriter createWriterFromFormat(String filenameWithoutExtension, SerializationFormat serializationFormat, TestCaseExecutionType executionType) {
        if (serializationFormat.equals(FormatService.getOutputFormat("html"))) {
            return DataWriterFactory.createHTMLWriter(executionType, filenameWithoutExtension + "." + serializationFormat.getExtension());
        }
        return new RDFFileWriter(filenameWithoutExtension + "." + serializationFormat.getExtension(), serializationFormat.getName());
    }

    public static DataWriter createWriterFromFormat(OutputStream outputStream, SerializationFormat serializationFormat, TestCaseExecutionType executionType) {
        if (serializationFormat.equals(FormatService.getOutputFormat("html"))) {
            return DataWriterFactory.createHTMLWriter(executionType, outputStream);
        }
        return new RDFStreamWriter(outputStream, serializationFormat.getName());
    }

    public static HTMLResultsWriter createHTMLWriter(TestCaseExecutionType type, String filename) {
        switch (type) {
            case statusTestCaseResult: {
                return new HTMLResultsStatusWriter(filename);
            }
            case aggregatedTestCaseResult: {
                return new HTMLResultsAggregateWriter(filename);
            }
            case rlogTestCaseResult: {
                return new HTMLResultsRlogWriter(filename);
            }
        }
        return null;
    }

    public static HTMLResultsWriter createHTMLWriter(TestCaseExecutionType type, OutputStream outputStream) {
        switch (type) {
            case statusTestCaseResult: {
                return new HTMLResultsStatusWriter(outputStream);
            }
            case aggregatedTestCaseResult: {
                return new HTMLResultsAggregateWriter(outputStream);
            }
            case rlogTestCaseResult: {
                return new HTMLResultsRlogWriter(outputStream);
            }
        }
        return null;
    }
}

