/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.Collection;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.DataReader;

public class DataFirstSuccessReader
extends DataReader {
    private final Collection<DataReader> readers;

    public DataFirstSuccessReader(Collection<DataReader> readers) {
        this.readers = readers;
    }

    @Override
    public void read(Model model) throws TripleReaderException {
        String message = "";
        for (DataReader r : this.readers) {
            try {
                r.read(model);
                return;
            }
            catch (TripleReaderException e) {
                message = message + "\n";
                if (e.getMessage() != null) {
                    message = message + e.getMessage();
                    continue;
                }
                message = message + e.toString();
            }
        }
        throw new TripleReaderException("Cannot read from any reader: " + message);
    }
}

