/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import java.net.URI;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.Source;

public final class CacheUtils {
    private CacheUtils() {
    }

    public static String getSchemaSourceCacheFilename(String testFolder, TestAppliesTo schemaType, String prefix, String uri) {
        return testFolder + schemaType.name() + "/" + CacheUtils.getCacheFolderForURI(uri) + prefix + ".cache." + schemaType.name() + ".ttl";
    }

    public static String getCacheFolderForURI(String uri) {
        String retVal = "";
        try {
            URI tmp = new URI(uri);
            String host = tmp.getHost();
            String path = tmp.getPath();
            retVal = host + path + "/";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getAutoPrefixForURI(String uri) {
        return uri.replace("http://", "").replace("https://", "").replaceAll("[?\"'\\/<>*|:#,&]", "_");
    }

    public static String getSourceAutoTestFile(String testFolder, Source source) {
        return CacheUtils.getFile(testFolder, source, "tests", source.getSourceType().name());
    }

    public static String getSourceManualTestFile(String testFolder, Source source) {
        return CacheUtils.getFile(testFolder, source, "tests", "Manual");
    }

    public static String getCacheFile(String testFolder, Source source) {
        return CacheUtils.getFile(testFolder, source, "cache", source.getSourceType().name());
    }

    private static String getFile(String testFolder, Source source, String type, String sourceType) {
        return testFolder + sourceType + "/" + CacheUtils.getCacheFolderForURI(source.getUri()) + source.getPrefix() + "." + type + "." + sourceType + ".ttl";
    }
}

