/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests.results;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Calendar;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.TestCase;

public abstract class TestCaseResult {
    private final TestCase testCase;
    private final XSDDateTime timestamp;

    protected TestCaseResult(TestCase testCase) {
        this.testCase = testCase;
        this.timestamp = new XSDDateTime(Calendar.getInstance());
    }

    public Resource serialize(Model model, String testExecutionURI) {
        return model.createResource(JenaUUID.generate().asString()).addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getNSFromPrefix("rut") + "TestCaseResult")).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getNSFromPrefix("prov"), (String)"wasGeneratedBy"), (RDFNode)model.createResource(testExecutionURI)).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getNSFromPrefix("rut"), (String)"testCase"), (RDFNode)model.createResource(this.getTestCase().getTestURI())).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getNSFromPrefix("dcterms"), (String)"date"), (RDFNode)model.createTypedLiteral((Object)this.getTimestamp(), (RDFDatatype)XSDDatatype.XSDdateTime));
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public XSDDateTime getTimestamp() {
        return this.timestamp;
    }
}

