/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.tests;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Collection;
import org.aksw.rdfunit.exceptions.TestCaseInstantiationException;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestCaseAnnotation;

public class PatternBasedTestCase
extends TestCase {
    private final Pattern pattern;
    private final Collection<Binding> bindings;

    public PatternBasedTestCase(String testURI, TestCaseAnnotation annotation, Pattern pattern, Collection<Binding> bindings) throws TestCaseInstantiationException {
        super(testURI, annotation);
        this.pattern = pattern;
        this.bindings = bindings;
        if (bindings.size() != pattern.getParameters().size()) {
            throw new TestCaseInstantiationException("Non valid bindings in TestCase: " + testURI);
        }
        this.validateQueries();
    }

    @Override
    public Resource serialize(Model model) {
        Resource resource = super.serialize(model);
        resource.addProperty(RDF.type, (RDFNode)model.createResource(PrefixNSService.getNSFromPrefix("rut") + "PatternBasedTestCase")).addProperty(ResourceFactory.createProperty((String)PrefixNSService.getNSFromPrefix("rut"), (String)"basedOnPattern"), (RDFNode)model.createResource(PrefixNSService.getNSFromPrefix("rutp") + this.pattern.getId())).addProperty(RDFS.comment, "SPARQL Query: \n" + PrefixNSService.getSparqlPrefixDecl() + this.getSparql() + "\n Prevalence SPARQL Query :\n" + this.getSparqlPrevalence());
        for (Binding binding : this.bindings) {
            resource.addProperty(ResourceFactory.createProperty((String)PrefixNSService.getNSFromPrefix("rut"), (String)"binding"), (RDFNode)binding.writeToModel(model));
        }
        return resource;
    }

    @Override
    public String getSparqlWhere() {
        return this.instantiateBindings(this.bindings, this.pattern.getSparqlWherePattern());
    }

    @Override
    public String getSparqlPrevalence() {
        return this.instantiateBindings(this.bindings, this.pattern.getSparqlPatternPrevalence());
    }

    private String instantiateBindings(Collection<Binding> bindings, String query) {
        String sparql = query;
        for (Binding b : bindings) {
            sparql = sparql.replace("%%" + b.getParameterId() + "%%", b.getValue());
        }
        return sparql;
    }
}

