/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.exceptions.UndefinedSchemaException;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.SourceFactory;

public final class SchemaService {
    private static final Map<String, String> schemata = new HashMap<String, String>();

    private SchemaService() {
    }

    public static void addSchemaDecl(String id, String uri, String url) {
        schemata.put(id, uri + "\t" + url);
    }

    public static void addSchemaDecl(String id, String uri) {
        schemata.put(id, uri);
    }

    public static SchemaSource getSource(String id) {
        return SchemaService.getSource(null, id);
    }

    public static SchemaSource getSource(String baseFolder, String id) {
        String sourceUriURL = schemata.get(id);
        if (sourceUriURL == null) {
            if (id.contains("/") || id.contains("\\")) {
                return SourceFactory.createSchemaSourceDereference(CacheUtils.getAutoPrefixForURI(id), id);
            }
            return null;
        }
        String[] split = sourceUriURL.split("\t");
        if (split.length == 2) {
            if (baseFolder != null) {
                return SourceFactory.createSchemaSourceFromCache(baseFolder, id, split[0], split[1]);
            }
            return SourceFactory.createSchemaSourceDereference(id, split[0], split[1]);
        }
        if (baseFolder != null) {
            return SourceFactory.createSchemaSourceFromCache(baseFolder, id, split[0]);
        }
        return SourceFactory.createSchemaSourceDereference(id, split[0]);
    }

    public static Collection<SchemaSource> getSourceList(String baseFolder, Collection<String> ids) throws UndefinedSchemaException {
        ArrayList<SchemaSource> sources = new ArrayList<SchemaSource>();
        for (String id : ids) {
            SchemaSource src = SchemaService.getSource(baseFolder, id.trim());
            if (src != null) {
                sources.add(src);
                continue;
            }
            throw new UndefinedSchemaException(id);
        }
        return sources;
    }

    public static Collection<SchemaSource> getSourceListAll(boolean fileCache, String baseFolder) throws UndefinedSchemaException {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.addAll(schemata.keySet());
        if (fileCache) {
            return SchemaService.getSourceList(baseFolder, prefixes);
        }
        return SchemaService.getSourceList(null, prefixes);
    }
}

