/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.services;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public final class PrefixNSService {
    private static final BidiMap<String, String> prefixNsBidiMap = new DualHashBidiMap();
    private static String sparqlPrefixDecl = null;

    private PrefixNSService() {
    }

    public static String getNSFromPrefix(String id) {
        return (String)PrefixNSService.getPrefixNsBidiMap().get((Object)id);
    }

    public static String getPrefixFromNS(String namespace) {
        return (String)PrefixNSService.getPrefixNsBidiMap().getKey((Object)namespace);
    }

    public static void setNSPrefixesInModel(Model model) {
        model.setNsPrefixes(PrefixNSService.getPrefixMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSparqlPrefixDecl() {
        if (sparqlPrefixDecl != null) return sparqlPrefixDecl;
        BidiMap<String, String> prefixCopy = PrefixNSService.getPrefixNsBidiMap();
        if (prefixCopy.isEmpty()) {
            return "";
        }
        Class<PrefixNSService> clazz = PrefixNSService.class;
        synchronized (PrefixNSService.class) {
            if (sparqlPrefixDecl != null) return sparqlPrefixDecl;
            sparqlPrefixDecl = PrefixNSService.generateSparqlPrefixes(prefixCopy);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sparqlPrefixDecl;
        }
    }

    private static Map<String, String> getPrefixMap() {
        return PrefixNSService.getPrefixNsBidiMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static BidiMap<String, String> getPrefixNsBidiMap() {
        if (!prefixNsBidiMap.isEmpty()) return prefixNsBidiMap;
        Class<PrefixNSService> clazz = PrefixNSService.class;
        synchronized (PrefixNSService.class) {
            if (!prefixNsBidiMap.isEmpty()) return prefixNsBidiMap;
            Model prefixModel = ModelFactory.createDefaultModel();
            try {
                prefixModel.read(PrefixNSService.class.getResourceAsStream("/org/aksw/rdfunit/prefixes.ttl"), null, "TURTLE");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot read refixes.ttl from resources", e);
            }
            Map prf = prefixModel.getNsPrefixMap();
            for (Map.Entry entry : prf.entrySet()) {
                prefixNsBidiMap.put(entry.getKey(), entry.getValue());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return prefixNsBidiMap;
        }
    }

    private static String generateSparqlPrefixes(Map<String, String> prefixMap) {
        StringBuilder sparqlPrefixes = new StringBuilder();
        for (Map.Entry<String, String> entry : prefixMap.entrySet()) {
            sparqlPrefixes.append(" PREFIX " + entry.getKey() + ": <" + entry.getValue() + "> \n");
        }
        return sparqlPrefixes.toString();
    }
}

