/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.exceptions.TripleWriterException;
import org.aksw.rdfunit.io.DataWriter;
import org.aksw.rdfunit.services.PrefixNSService;

public class RDFStreamWriter
extends DataWriter {
    private final OutputStream outputStream;
    private final String filetype;

    public RDFStreamWriter(OutputStream outputStream, String filetype) {
        this.outputStream = outputStream;
        this.filetype = filetype;
    }

    public RDFStreamWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.filetype = "TURTLE";
    }

    @Override
    public void write(QueryExecutionFactory qef) throws TripleWriterException {
        try {
            Model model = SparqlUtils.getModelFromQueryFactory(qef);
            PrefixNSService.setNSPrefixesInModel(model);
            model.write(this.outputStream, this.filetype);
        }
        catch (Exception e) {
            throw new TripleWriterException("Error writing in OutputStream: " + e.getMessage(), e);
        }
    }

    public static OutputStream getOutputStreamFromFilename(String filename) {
        try {
            return new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

