/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.enums.PatternParameterConstraints;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.services.PrefixNSService;
import org.aksw.rdfunit.tests.results.ResultAnnotation;

public final class PatternUtils {
    private PatternUtils() {
    }

    public static Collection<Pattern> instantiatePatternsFromModel(QueryExecutionFactory queryFactory) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String sparqlSelectPatterns = PrefixNSService.getSparqlPrefixDecl() + "SELECT distinct ?sparqlPattern ?id ?desc ?sparql ?sparqlPrev ?variable WHERE { " + " ?sparqlPattern a rut:Pattern ; " + "  dcterms:identifier ?id ; " + "  dcterms:description ?desc ; " + "  rut:sparqlWherePattern ?sparql ; " + "  rut:sparqlPrevalencePattern ?sparqlPrev ; " + "} ORDER BY ?sparqlPattern";
        String sparqlSelectParameters = PrefixNSService.getSparqlPrefixDecl() + " SELECT distinct ?parameterURI ?id ?constraint ?constraintPattern WHERE { " + " %%PATTERN%%  rut:parameter ?parameterURI . " + " ?parameterURI a rut:Parameter . " + " ?parameterURI dcterms:identifier ?id . " + " OPTIONAL {?parameterURI rut:parameterConstraint ?constraint .}" + " OPTIONAL {?parameterURI rut:constraintPattern ?constraintPattern .}" + " } ";
        QueryExecution qe = queryFactory.createQueryExecution(sparqlSelectPatterns);
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.next();
            String patternURI = qs.get("sparqlPattern").toString();
            String id = qs.get("id").toString();
            String desc = qs.get("desc").toString();
            String sparql = qs.get("sparql").toString();
            String sparqlPrev = qs.get("sparqlPrev").toString();
            ArrayList<PatternParameter> parameters = new ArrayList<PatternParameter>();
            QueryExecution qeNested = queryFactory.createQueryExecution(sparqlSelectParameters.replace("%%PATTERN%%", "<" + patternURI + ">"));
            ResultSet resultsNested = qeNested.execSelect();
            while (resultsNested.hasNext()) {
                QuerySolution parSol = resultsNested.next();
                String parameterURI = parSol.get("parameterURI").toString();
                String parameterID = parSol.get("id").toString();
                String constrainStr = "";
                if (parSol.contains("constrain")) {
                    constrainStr = parSol.get("constrain").toString();
                }
                String constrainPat = "";
                if (parSol.contains("constraintPattern")) {
                    constrainPat = parSol.get("constraintPattern").toString();
                }
                PatternParameterConstraints constrain = PatternParameterConstraints.resolve(constrainStr);
                parameters.add(new PatternParameter(parameterURI, parameterID, constrain, constrainPat));
            }
            qeNested.close();
            Collection<ResultAnnotation> annotations = SparqlUtils.getResultAnnotations(queryFactory, patternURI);
            Pattern pat = new Pattern(id, desc, sparql, sparqlPrev, parameters, annotations);
            if (pat.isValid()) {
                patterns.add(pat);
                continue;
            }
            System.err.println("Pattern not valid: " + pat.getId());
            System.exit(-1);
        }
        qe.close();
        return patterns;
    }
}

