/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.UndefinedSchemaException;
import org.aksw.rdfunit.exceptions.UndefinedSerializationException;
import org.aksw.rdfunit.io.RDFStreamReader;
import org.aksw.rdfunit.io.format.SerializationFormat;
import org.aksw.rdfunit.services.FormatService;
import org.aksw.rdfunit.services.SchemaService;
import org.aksw.rdfunit.sources.DatasetSource;
import org.aksw.rdfunit.sources.DumpSource;
import org.aksw.rdfunit.sources.EnrichedSchemaSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.sources.SourceFactory;

public class RDFUnitConfiguration {
    private final String datasetURI;
    private String prefix = null;
    private final String dataFolder;
    private final String testFolder;
    private String endpointURI = null;
    private Collection<String> endpointGraphs = null;
    private long endpointDelayinMS = 7000L;
    private long endpointCacheTTL = 604800000L;
    private long endpointPagination = 900L;
    private String customDereferenceURI = null;
    private String customTextSource = null;
    private SerializationFormat customTextFormat = null;
    private Collection<SchemaSource> schemas = null;
    private EnrichedSchemaSource enrichedSchema = null;
    private boolean testCacheEnabled = true;
    private boolean manualTestsEnabled = true;
    private TestCaseExecutionType resultLevelReporting = TestCaseExecutionType.aggregatedTestCaseResult;
    private Collection<SerializationFormat> outputFormats = null;
    private boolean calculateCoverageEnabled = false;

    public RDFUnitConfiguration(String datasetURI, String dataFolder) {
        this(datasetURI, dataFolder, dataFolder + "tests/");
    }

    public RDFUnitConfiguration(String datasetURI, String dataFolder, String testFolder) {
        this.datasetURI = datasetURI;
        this.dataFolder = dataFolder;
        this.testFolder = testFolder;
        this.prefix = CacheUtils.getAutoPrefixForURI(datasetURI);
    }

    public void setEndpointConfiguration(String endpointURI, Collection<String> endpointGraphs) {
        this.setEndpointConfiguration(endpointURI, endpointGraphs, this.endpointDelayinMS, this.endpointCacheTTL, this.endpointPagination);
    }

    public void setEndpointConfiguration(String endpointURI, Collection<String> endpointGraphs, long endpointDelayinMS, long endpointCacheTTL, long endpointPagination) {
        this.endpointURI = endpointURI;
        this.endpointGraphs = new ArrayList<String>();
        this.endpointGraphs.addAll(endpointGraphs);
        this.endpointDelayinMS = endpointDelayinMS;
        this.endpointCacheTTL = endpointCacheTTL;
        this.endpointPagination = endpointPagination;
    }

    public void setCustomDereferenceURI(String customDereferenceURI) {
        this.customDereferenceURI = customDereferenceURI;
    }

    public void setCustomTextSource(String text, String format) throws UndefinedSerializationException {
        this.customTextSource = text;
        this.customTextFormat = FormatService.getInputFormat(format);
        if (this.customTextFormat == null) {
            throw new UndefinedSerializationException(format);
        }
        this.endpointURI = null;
        this.customDereferenceURI = null;
    }

    public void setSchemataFromPrefixes(Collection<String> schemaPrefixes) throws UndefinedSchemaException {
        this.schemas = SchemaService.getSourceList(this.testFolder, schemaPrefixes);
    }

    public void setSchemata(Collection<SchemaSource> schemata) {
        this.schemas = new ArrayList<SchemaSource>();
        this.schemas.addAll(schemata);
    }

    public void setEnrichedSchema(String enrichedSchemaPrefix) {
        if (enrichedSchemaPrefix != null && !enrichedSchemaPrefix.isEmpty()) {
            this.enrichedSchema = SourceFactory.createEnrichedSchemaSourceFromCache(this.testFolder, enrichedSchemaPrefix, this.datasetURI);
        }
    }

    public Collection<SchemaSource> getAllSchemata() {
        ArrayList<SchemaSource> allSchemas = new ArrayList<SchemaSource>();
        if (this.schemas != null) {
            allSchemas.addAll(this.schemas);
        }
        if (this.enrichedSchema != null) {
            allSchemas.add(this.enrichedSchema);
        }
        return allSchemas;
    }

    public Source getTestSource() {
        if (this.endpointURI != null && !this.endpointURI.isEmpty()) {
            return new DatasetSource(CacheUtils.getAutoPrefixForURI(this.datasetURI), this.datasetURI, this.endpointURI, this.endpointGraphs, this.getAllSchemata());
        }
        if (this.customTextSource != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.customTextSource.getBytes());
            RDFStreamReader textReader = new RDFStreamReader(is, this.customTextFormat.getName());
            return new DumpSource(CacheUtils.getAutoPrefixForURI(this.datasetURI), this.datasetURI, textReader, this.getAllSchemata());
        }
        String tmp_customDereferenceURI = this.datasetURI;
        if (this.customDereferenceURI != null && !this.customDereferenceURI.isEmpty()) {
            tmp_customDereferenceURI = this.customDereferenceURI;
        }
        return new DumpSource(CacheUtils.getAutoPrefixForURI(this.datasetURI), this.datasetURI, tmp_customDereferenceURI, this.getAllSchemata());
    }

    public void setOutputFormatTypes(Collection<String> outputNames) throws UndefinedSerializationException {
        this.outputFormats = new ArrayList<SerializationFormat>();
        boolean invalidInput = false;
        for (String name : outputNames) {
            SerializationFormat serializationFormat = FormatService.getOutputFormat(name);
            if (serializationFormat != null) {
                this.outputFormats.add(serializationFormat);
                continue;
            }
            throw new UndefinedSerializationException(name);
        }
        if (this.outputFormats.isEmpty()) {
            throw new UndefinedSerializationException("");
        }
    }

    public boolean isTestCacheEnabled() {
        return this.testCacheEnabled;
    }

    public void setTestCacheEnabled(boolean testCacheEnabled) {
        this.testCacheEnabled = testCacheEnabled;
    }

    public boolean isManualTestsEnabled() {
        return this.manualTestsEnabled;
    }

    public void setManualTestsEnabled(boolean manualTestsEnabled) {
        this.manualTestsEnabled = manualTestsEnabled;
    }

    public TestCaseExecutionType getResultLevelReporting() {
        return this.resultLevelReporting;
    }

    public void setResultLevelReporting(TestCaseExecutionType resultLevelReporting) {
        this.resultLevelReporting = resultLevelReporting;
    }

    public boolean isCalculateCoverageEnabled() {
        return this.calculateCoverageEnabled;
    }

    public void setCalculateCoverageEnabled(boolean calculateCoverageEnabled) {
        this.calculateCoverageEnabled = calculateCoverageEnabled;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public String getTestFolder() {
        return this.testFolder;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDatasetURI() {
        return this.datasetURI;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public Collection<String> getEndpointGraphs() {
        return this.endpointGraphs;
    }

    public String getCustomDereferenceURI() {
        return this.customDereferenceURI;
    }

    public EnrichedSchemaSource getEnrichedSchema() {
        return this.enrichedSchema;
    }

    public Collection<SerializationFormat> getOutputFormats() {
        return this.outputFormats;
    }

    public SerializationFormat geFirstOutputFormat() {
        return RDFUnitUtils.getFirstItemInCollection(this.outputFormats);
    }
}

