/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.RDFDereferenceReader;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;

public class DumpSource
extends Source {
    private final DataReader dumpReader;

    public DumpSource(String prefix, String uri) {
        this(prefix, uri, new RDFDereferenceReader(uri), null);
    }

    public DumpSource(String prefix, String uri, String location) {
        this(prefix, uri, new RDFDereferenceReader(location), null);
    }

    public DumpSource(String prefix, String uri, DataReader dumpReader) {
        this(prefix, uri, dumpReader, null);
    }

    public DumpSource(String prefix, String uri, Collection<SchemaSource> schemata) {
        this(prefix, uri, new RDFDereferenceReader(uri), schemata);
    }

    public DumpSource(String prefix, String uri, DataReader dumpReader, Collection<SchemaSource> schemata) {
        super(prefix, uri);
        this.dumpReader = dumpReader;
        if (schemata != null) {
            this.addReferencesSchemata(schemata);
        }
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    @Override
    protected QueryExecutionFactory initQueryFactory() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)ModelFactory.createDefaultModel());
        try {
            this.dumpReader.read((Model)model);
            for (Source source : this.getReferencesSchemata()) {
                QueryExecutionFactory qef = source.getExecutionFactory();
                if (!(qef instanceof QueryExecutionFactoryModel)) continue;
                model.add(((QueryExecutionFactoryModel)qef).getModel());
            }
        }
        catch (Exception e) {
            log.error("Cannot read dump URI: " + this.getUri() + " Reason: " + e.getMessage());
            e.printStackTrace();
        }
        return new QueryExecutionFactoryModel((Model)model);
    }
}

