/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.sources;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontendImpl;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDao;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDaoPostgres;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDataSource;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.sources.Source;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.tools.RunScript;

public class DatasetSource
extends Source {
    private final String sparqlEndpoint;
    private final Collection<String> sparqlGraph;

    public DatasetSource(String prefix, String uri) {
        this(prefix, uri, uri, new ArrayList<String>(), null);
    }

    public DatasetSource(String prefix, String uri, String sparqlEndpoint, Collection<String> sparqlGraph, Collection<SchemaSource> schemata) {
        super(prefix, uri);
        this.sparqlEndpoint = sparqlEndpoint;
        this.sparqlGraph = new ArrayList<String>(sparqlGraph);
        if (schemata != null) {
            this.addReferencesSchemata(schemata);
        }
    }

    public DatasetSource(DatasetSource source) {
        this(source.getPrefix(), source.getUri(), source.getSparqlEndpoint(), source.getSparqlGraphs(), source.getReferencesSchemata());
    }

    @Override
    public TestAppliesTo getSourceType() {
        return TestAppliesTo.Dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected QueryExecutionFactory initQueryFactory() {
        QueryExecutionFactoryHttp qef = this.getSparqlGraphs() == null || this.getSparqlGraphs().isEmpty() ? new QueryExecutionFactoryHttp(this.getSparqlEndpoint()) : new QueryExecutionFactoryHttp(this.getSparqlEndpoint(), this.getSparqlGraphs());
        QueryExecutionFactoryHttp qefBackup = qef = new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, 7000L);
        try {
            long timeToLive = 604800000L;
            Class.forName("org.h2.Driver");
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL("jdbc:h2:file:./cache/sparql/" + this.getPrefix() + ";DB_CLOSE_DELAY=-1");
            dataSource.setUser("sa");
            dataSource.setPassword("sa");
            String schemaResourceName = "/org/aksw/jena_sparql_api/cache/cache-schema-pgsql.sql";
            InputStream in = CacheBackendDao.class.getResourceAsStream(schemaResourceName);
            if (in == null) {
                throw new RuntimeException("Failed to load resource: " + schemaResourceName);
            }
            InputStreamReader reader = new InputStreamReader(in);
            try (Connection conn = dataSource.getConnection();){
                RunScript.execute((Connection)conn, (Reader)reader);
            }
            CacheBackendDaoPostgres dao = new CacheBackendDaoPostgres();
            CacheBackendDataSource cacheBackend = new CacheBackendDataSource((DataSource)dataSource, (CacheBackendDao)dao);
            CacheFrontendImpl cacheFrontend = new CacheFrontendImpl((CacheBackend)cacheBackend);
            qef = new QueryExecutionFactoryCacheEx((QueryExecutionFactory)qef, (CacheFrontend)cacheFrontend);
        }
        catch (Exception e) {
            qef = qefBackup;
        }
        qef = new QueryExecutionFactoryPaginated((QueryExecutionFactory)qef, 900L);
        return qef;
    }

    public String getSparqlEndpoint() {
        return this.sparqlEndpoint;
    }

    public Collection<String> getSparqlGraphs() {
        return this.sparqlGraph;
    }
}

