/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.io;

import java.util.ArrayList;
import org.aksw.rdfunit.io.DataFirstSuccessReader;
import org.aksw.rdfunit.io.DataReadAndCacheReader;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.RDFDereferenceReader;
import org.aksw.rdfunit.io.RDFFileWriter;
import org.aksw.rdfunit.io.RDFStreamReader;

public class DataReaderFactory {
    public static DataReader createFileOrDereferenceReader(String filenameOrUri) {
        return DataReaderFactory.createFileOrDereferenceReader(filenameOrUri, filenameOrUri);
    }

    public static DataReader createFileOrDereferenceReader(String filename, String uri) {
        ArrayList<DataReader> readers = new ArrayList<DataReader>();
        readers.add(new RDFStreamReader(filename));
        readers.add(new RDFDereferenceReader(uri));
        DataFirstSuccessReader r = new DataFirstSuccessReader(readers);
        RDFFileWriter w = new RDFFileWriter(filename, true);
        return new DataReadAndCacheReader(r, w);
    }

    public static DataReader createFileOrResourceReader(String filename, String resource) {
        ArrayList<DataReader> readers = new ArrayList<DataReader>();
        readers.add(new RDFStreamReader(filename));
        readers.add(new RDFStreamReader(DataReaderFactory.class.getResourceAsStream(resource)));
        return new DataFirstSuccessReader(readers);
    }
}

