/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit.Utils;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.Utils.SparqlUtils;
import org.aksw.rdfunit.enums.TestAppliesTo;
import org.aksw.rdfunit.enums.TestGenerationType;
import org.aksw.rdfunit.exceptions.BindingException;
import org.aksw.rdfunit.exceptions.TripleWriterException;
import org.aksw.rdfunit.io.DataWriter;
import org.aksw.rdfunit.patterns.Pattern;
import org.aksw.rdfunit.patterns.PatternParameter;
import org.aksw.rdfunit.services.PatternService;
import org.aksw.rdfunit.services.PrefixService;
import org.aksw.rdfunit.sources.Source;
import org.aksw.rdfunit.tests.Binding;
import org.aksw.rdfunit.tests.ManualTestCase;
import org.aksw.rdfunit.tests.PatternBasedTestCase;
import org.aksw.rdfunit.tests.TestAutoGenerator;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestCaseAnnotation;
import org.aksw.rdfunit.tests.results.ResultAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);

    public static Collection<TestAutoGenerator> instantiateTestGeneratorsFromModel(QueryExecutionFactory queryFactory) {
        ArrayList<TestAutoGenerator> autoGenerators = new ArrayList<TestAutoGenerator>();
        String sparqlSelect = RDFUnitUtils.getAllPrefixes() + " SELECT ?generator ?desc ?query ?patternID WHERE { " + " ?generator " + "    a rut:TestGenerator ; " + "    dcterms:description ?desc ; " + "    rut:sparqlGenerator ?query ; " + "    rut:basedOnPattern ?pattern . " + " ?pattern dcterms:identifier ?patternID ." + "} ";
        QueryExecution qe = queryFactory.createQueryExecution(sparqlSelect);
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.next();
            String generator = qs.get("generator").toString();
            String description = qs.get("desc").toString();
            String query = qs.get("query").toString();
            String patternID = qs.get("patternID").toString();
            Collection<ResultAnnotation> annotations = SparqlUtils.getResultAnnotations(queryFactory, generator);
            TestAutoGenerator tag = new TestAutoGenerator(generator, description, query, PatternService.getPattern(patternID), annotations);
            if (tag.isValid()) {
                autoGenerators.add(tag);
                continue;
            }
            log.error("AutoGenerator not valid: " + tag.getURI());
            System.exit(-1);
        }
        qe.close();
        return autoGenerators;
    }

    public static Collection<TestCase> instantiateTestsFromAG(Collection<TestAutoGenerator> autoGenerators, Source source) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        for (TestAutoGenerator tag : autoGenerators) {
            tests.addAll(tag.generate(source));
        }
        return tests;
    }

    public static Collection<TestCase> instantiateTestsFromModel(Model model) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        QueryExecutionFactoryModel qef = new QueryExecutionFactoryModel(model);
        String manualTestsSelectSparql = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?testURI WHERE {" + " ?testURI a rut:ManualTestCase }";
        QueryExecution qe = qef.createQueryExecution(manualTestsSelectSparql);
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.next();
            String testURI = qs.get("testURI").toString();
            ManualTestCase tc = TestUtils.instantiateSingleManualTestFromModel((QueryExecutionFactory)qef, testURI);
            if (tc == null) continue;
            tests.add(tc);
        }
        String patternTestsSelectSparql = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?testURI WHERE {" + " ?testURI a rut:PatternBasedTestCase } ";
        qe = qef.createQueryExecution(patternTestsSelectSparql);
        results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.next();
            String testURI = qs.get("testURI").toString();
            PatternBasedTestCase tc = TestUtils.instantiateSinglePatternTestFromModel((QueryExecutionFactory)qef, testURI);
            if (tc == null) continue;
            tests.add(tc);
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManualTestCase instantiateSingleManualTestFromModel(QueryExecutionFactory qef, String testURI) {
        String sparqlSelect = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?description ?appliesTo ?generated ?source ?sparqlWhere ?sparqlPrevalence ?testGenerator ?testCaseLogLevel WHERE { " + " <" + testURI + "> " + "    dcterms:description  ?description ;" + "    rut:appliesTo        ?appliesTo ;" + "    rut:generated        ?generated ;" + "    rut:source           ?source ;" + "    rut:testCaseLogLevel ?testCaseLogLevel ;" + "    rut:sparqlWhere      ?sparqlWhere ;" + "    rut:sparqlPrevalence ?sparqlPrevalence ." + " OPTIONAL {<" + testURI + ">  rut:testGenerator ?testGenerator .}" + "} ";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparqlSelect);
            ResultSet results = qe.execSelect();
            if (results.hasNext()) {
                QuerySolution qs = results.next();
                String description = qs.get("description").toString();
                String appliesTo = qs.get("appliesTo").toString();
                String generated = qs.get("generated").toString();
                String source = qs.get("source").toString();
                String testCaseLogLevel = qs.get("testCaseLogLevel").toString();
                String sparqlWhere = qs.get("sparqlWhere").toString();
                String sparqlPrevalence = qs.get("sparqlPrevalence").toString();
                Collection<String> referencesLst = TestUtils.getReferencesFromTestCase(qef, testURI);
                String testGenerator = "";
                if (qs.contains("testGenerator")) {
                    testGenerator = qs.get("testGenerator").toString();
                }
                Collection<ResultAnnotation> resultAnnotations = SparqlUtils.getResultAnnotations(qef, testURI);
                TestCaseAnnotation annotation = new TestCaseAnnotation(TestGenerationType.resolve(generated), testGenerator, TestAppliesTo.resolve(appliesTo), source, referencesLst, description, testCaseLogLevel, resultAnnotations);
                if (!results.hasNext()) {
                    ManualTestCase manualTestCase = new ManualTestCase(testURI, annotation, sparqlWhere, sparqlPrevalence);
                    return manualTestCase;
                }
            }
        }
        log.error("Cannot instantiate test case: " + testURI);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatternBasedTestCase instantiateSinglePatternTestFromModel(QueryExecutionFactory qef, String testURI) {
        String sparqlSelect = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?description ?appliesTo ?generated ?source ?basedOnPattern ?testGenerator ?testCaseLogLevel WHERE { " + " <" + testURI + "> " + "    dcterms:description ?description ;" + "    rut:appliesTo      ?appliesTo ;" + "    rut:generated      ?generated ;" + "    rut:source         ?source ;" + "    rut:testCaseLogLevel ?testCaseLogLevel ;" + "    rut:basedOnPattern ?basedOnPattern ;" + " OPTIONAL {<" + testURI + ">  rut:testGenerator ?testGenerator .}" + "} ";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparqlSelect);
            ResultSet results = qe.execSelect();
            if (results.hasNext()) {
                QuerySolution qs = results.next();
                String description = qs.get("description").toString();
                String appliesTo = qs.get("appliesTo").toString();
                String generated = qs.get("generated").toString();
                String source = qs.get("source").toString();
                String testCaseLogLevel = qs.get("testCaseLogLevel").toString();
                String patternURI = qs.get("basedOnPattern").toString();
                Pattern pattern = PatternService.getPattern(patternURI.replace(PrefixService.getPrefix("rutp"), ""));
                if (pattern == null) {
                    log.error("Pattern does not exists for test: " + testURI);
                    PatternBasedTestCase patternBasedTestCase = null;
                    return patternBasedTestCase;
                }
                Collection<String> referencesLst = TestUtils.getReferencesFromTestCase(qef, testURI);
                Collection<Binding> bindings = TestUtils.getBindingsFromTestCase(qef, testURI, pattern);
                String testGenerator = "";
                if (qs.contains("testGenerator")) {
                    testGenerator = qs.get("testGenerator").toString();
                }
                Collection<ResultAnnotation> resultAnnotations = SparqlUtils.getResultAnnotations(qef, testURI);
                TestCaseAnnotation annotation = new TestCaseAnnotation(TestGenerationType.resolve(generated), testGenerator, TestAppliesTo.resolve(appliesTo), source, referencesLst, description, testCaseLogLevel, resultAnnotations);
                if (!results.hasNext()) {
                    PatternBasedTestCase patternBasedTestCase = new PatternBasedTestCase(testURI, annotation, pattern, bindings);
                    return patternBasedTestCase;
                }
            }
        }
        log.error("Cannot instantiate test case: " + testURI);
        return null;
    }

    public static void writeTestsToFile(Collection<TestCase> tests, DataWriter testCache) {
        Model model = ModelFactory.createDefaultModel();
        for (TestCase t : tests) {
            t.serialize(model);
        }
        try {
            model.setNsPrefixes(PrefixService.getPrefixMap());
            testCache.write(model);
        }
        catch (TripleWriterException e) {
            log.error("Cannot cache tests: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getReferencesFromTestCase(QueryExecutionFactory qef, String testURI) {
        ArrayList<String> references = new ArrayList<String>();
        String sparqlReferencesSelect = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?references WHERE { " + " <" + testURI + "> rut:references ?references . }";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparqlReferencesSelect);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                references.add(qs.get("references").toString());
            }
        }
        return references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Binding> getBindingsFromTestCase(QueryExecutionFactory qef, String testURI, Pattern pattern) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        String sparqlReferencesSelect = RDFUnitUtils.getAllPrefixes() + " SELECT DISTINCT ?parameter ?value WHERE { " + " <" + testURI + "> rut:binding ?binding ." + " ?binding rut:bindingValue ?value ;" + "          rut:parameter ?parameter }";
        try (QueryExecution qe = null;){
            qe = qef.createQueryExecution(sparqlReferencesSelect);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String parameterURI = qs.get("parameter").toString();
                PatternParameter parameter = pattern.getParameter(parameterURI);
                if (parameter == null) {
                    log.error("Test instantiation error: Pattern " + pattern.getId() + " does not contain parameter " + parameterURI + " in TestCase: " + testURI);
                    continue;
                }
                RDFNode value = qs.get("value");
                try {
                    bindings.add(new Binding(parameter, value));
                }
                catch (BindingException e) {
                    log.error("Non valid binding for parameter " + parameter.getId() + " in Test: " + testURI);
                }
            }
        }
        return bindings;
    }

    public static String generateTestURI(String sourcePrefix, Pattern pattern, Collection<Binding> bindings, String generatorURI) {
        String testURI = PrefixService.getPrefix("rutt") + sourcePrefix + "-" + pattern.getId() + "-";
        String string2hash = generatorURI;
        for (Binding binding : bindings) {
            string2hash = string2hash + binding.getValue();
        }
        String md5Hash = TestUtils.MD5(string2hash);
        testURI = md5Hash == null ? testURI + JenaUUID.generate().asString() : testURI + md5Hash;
        return testURI;
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte anArray : array) {
                sb.append(Integer.toHexString(anArray & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

