/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.rdfunit;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.rdfunit.RDFUnit;
import org.aksw.rdfunit.Utils.CacheUtils;
import org.aksw.rdfunit.Utils.RDFUnitUtils;
import org.aksw.rdfunit.Utils.TestUtils;
import org.aksw.rdfunit.enums.TestCaseExecutionType;
import org.aksw.rdfunit.exceptions.TripleReaderException;
import org.aksw.rdfunit.io.DataFirstSuccessReader;
import org.aksw.rdfunit.io.DataModelReader;
import org.aksw.rdfunit.io.DataReader;
import org.aksw.rdfunit.io.RDFDereferenceReader;
import org.aksw.rdfunit.io.RDFStreamReader;
import org.aksw.rdfunit.sources.DumpSource;
import org.aksw.rdfunit.sources.SchemaSource;
import org.aksw.rdfunit.tests.TestCase;
import org.aksw.rdfunit.tests.TestSuite;
import org.aksw.rdfunit.tests.executors.TestExecutor;
import org.aksw.rdfunit.tests.executors.monitors.SimpleTestExecutorMonitor;

public class ExampleRDFUnitWrapperForNIF {
    private static String nifOntologyURI = "http://persistence.uni-leipzig.org/nlp2rdf/ontologies/nif-core#";
    private static TestSuite testSuite = null;
    private static DataReader nifOntologyReader = null;

    private ExampleRDFUnitWrapperForNIF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TestSuite getTestSuite() {
        if (testSuite != null) return testSuite;
        Class<ExampleRDFUnitWrapperForNIF> clazz = ExampleRDFUnitWrapperForNIF.class;
        synchronized (ExampleRDFUnitWrapperForNIF.class) {
            Collection<TestCase> manualTestCases;
            if (testSuite != null) return testSuite;
            ArrayList<DataReader> nifReaderList = new ArrayList<DataReader>();
            nifReaderList.add(new RDFStreamReader(ExampleRDFUnitWrapperForNIF.class.getResourceAsStream("org/uni-leipzig/persistence/nlp2rdf/nif-core/nif-core.ttl")));
            nifReaderList.add(new RDFDereferenceReader(nifOntologyURI));
            nifOntologyReader = new DataFirstSuccessReader(nifReaderList);
            SchemaSource nifSchema = new SchemaSource("nif", nifOntologyURI, nifOntologyReader);
            RDFStreamReader manualTestCaseReader = new RDFStreamReader(ExampleRDFUnitWrapperForNIF.class.getResourceAsStream(CacheUtils.getSourceManualTestFile("/org/aksw/rdfunit/tests/", nifSchema)));
            try {
                manualTestCases = TestUtils.instantiateTestsFromModel(manualTestCaseReader.read());
            }
            catch (TripleReaderException e) {
                manualTestCases = new ArrayList<TestCase>();
            }
            RDFUnit rdfunit = new RDFUnit();
            try {
                rdfunit.initPatternsAndGenerators(RDFUnitUtils.getPatternsFromResource(), RDFUnitUtils.getAutoGeneratorsFromResource());
            }
            catch (TripleReaderException e) {
                testSuite = new TestSuite(manualTestCases);
                // ** MonitorExit[var0] (shouldn't be in output)
                return testSuite;
            }
            Collection<TestCase> autoTestCases = TestUtils.instantiateTestsFromAG(rdfunit.getAutoGenerators(), nifSchema);
            ArrayList<TestCase> allTestCases = new ArrayList<TestCase>();
            allTestCases.addAll(autoTestCases);
            allTestCases.addAll(manualTestCases);
            testSuite = new TestSuite(allTestCases);
            // ** MonitorExit[var0] (shouldn't be in output)
            return testSuite;
        }
    }

    public static Model validate(Model input) {
        SimpleTestExecutorMonitor testExecutorMonitor = new SimpleTestExecutorMonitor();
        TestExecutor testExecutor = TestExecutor.initExecutorFactory(TestCaseExecutionType.rlogTestCaseResult);
        testExecutor.addTestExecutorMonitor(testExecutorMonitor);
        DumpSource modelSource = new DumpSource("prefix", "uri", new DataModelReader(input), Arrays.asList(new SchemaSource("nif", nifOntologyURI, nifOntologyReader)));
        testExecutor.execute(modelSource, ExampleRDFUnitWrapperForNIF.getTestSuite(), 0);
        return testExecutorMonitor.getModel();
    }
}

